<!DOCTYPE html>
<html lang="en">
<!-- head area start -->
    <?php include 'layout/partials/head.php';?>
<!-- head area end -->

<body>

    <!-- HEADER AREA -->
        <?php include 'layout/header/header-six.php';?>
    <!-- HEADER AREA END -->

    <!-- HERO BANNER ONE -->
    <section class="rts-hero wp__banner">
        <div class="rts-hero__video">
            <video loop muted autoplay src="assets/images/video/wp-hosting.mp4"></video>
        </div>
        <div class="container">
            <div class="row justify-content-center align-items-end position-relative">
                <div class="col-lg-6">
                    <div class="rts-hero__content">

                        <h1 class="heading" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            Better Speed For WordPress Sites.
                        </h1>
                        <p class="description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                            Developing smart solutions in-house and adopting the latest speed and security technologies
                            is our passion.</p>
                        <div class="rts-hero__content--group" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                            <a href="pricing.php" class="primary__btn white__bg">Get Started <i
                                    class="fa-regular fa-long-arrow-right"></i></a>
                            <a href="pricing-two.php" class="btn__zero plan__btn">Plans & Pricing <i
                                    class="fa-regular fa-long-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HERO BANNER ONE END -->

    <!-- HOSTING OPTION -->
    <div class="rts-hosting-type wp__hosting__option section__padding">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="rts-hosting-type__section">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Multiple
                            Hosting Options</h3>
                        <p data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">No matter your hosting
                            requirements, our platform will fit your needs.</p>
                        <div class="rts-slider__btn hosting-slider">
                            <div class="slide__btn rts-prev"><i class="fa-light fa-arrow-left"></i></div>
                            <div class="slide__btn rts-next"><i class="fa-light fa-arrow-right"></i></div>
                        </div>

                    </div>
                </div>
            </div>
            <!-- hosting option -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="rts-hosting-type__slider">
                        <div class="swiper-wrapper">
                            <!-- single package -->
                            <div class="swiper-slide">
                                <div class="rts-hosting-type__single">
                                    <div class="hosting-icon">
                                        <img src="assets/images/hosting/03.svg" alt="">
                                    </div>
                                    <a href="wordpress-hosting.php" class="title">WordPress Hosting</a>
                                    <p class="excerpt">Manage your WordPress sites easily and more freedom.</p>
                                    <h6 class="price__start">Starting from $2.95/month</h6>
                                    <a href="wordpress-hosting.php" class="primary__btn border__btn">See Plan <i
                                            class="fa-regular fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                            <!-- single package end -->
                            <!-- single package -->
                            <div class="swiper-slide">
                                <div class="rts-hosting-type__single">
                                    <div class="hosting-icon">
                                        <img src="assets/images/hosting/04.svg" alt="">
                                    </div>
                                    <a href="wordpress-hosting.php" class="title">Web Hosting</a>
                                    <p class="excerpt">Manage your WordPress sites easily and more freedom.</p>
                                    <h6 class="price__start">Starting from $2.95/month</h6>
                                    <a href="wordpress-hosting.php" class="primary__btn border__btn">See Plan <i
                                            class="fa-regular fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                            <!-- single package end -->
                            <!-- single package -->
                            <div class="swiper-slide">
                                <div class="rts-hosting-type__single">
                                    <div class="hosting-icon">
                                        <img src="assets/images/hosting/02.svg" alt="">
                                    </div>
                                    <a href="vps-hosting.php" class="title">Vps Hosting</a>
                                    <p class="excerpt">Manage your WordPress sites easily and more freedom.</p>
                                    <h6 class="price__start">Starting from $2.95/month</h6>
                                    <a href="vps-hosting.php" class="primary__btn border__btn">See Plan <i
                                            class="fa-regular fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                            <!-- single package end -->
                            <!-- single package -->
                            <div class="swiper-slide">
                                <div class="rts-hosting-type__single">
                                    <div class="hosting-icon">
                                        <img src="assets/images/hosting/01.svg" alt="">
                                    </div>
                                    <a href="shared-hosting.php" class="title">Shared Hosting</a>
                                    <p class="excerpt">Manage your WordPress sites easily and more freedom.</p>
                                    <h6 class="price__start">Starting from $2.95/month</h6>
                                    <a href="shared-hosting.php" class="primary__btn border__btn">See Plan <i
                                            class="fa-regular fa-long-arrow-right"></i></a>
                                </div>
                            </div>
                            <!-- single package end -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTING OPTION END -->

    <!-- SEARCH DOMAIN -->
    <div class="rts-domain-finder wp__hosting__option">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="rts-domain-finder__content domain-finder-bg">
                        <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">A name that looks good on
                            a billboard.</h3>
                        <form action="https://hostie-whmcs.themewant.com/cart.php" class="domain-checker" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                            <input type="text" id="domain-name" name="query" placeholder="Register a domain name to start" required>
                            <input type="hidden" name="domain" value="register">
                            <input type="hidden" name="a" value="add">
                            <button type="submit" name="domain_type">search domain</button>
                        </form>
                        <div class="compare">
                            <div class="compare__list">
                                <ul>
                                    <li data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">Compare:</li>
                                    <li data-sal="slide-down" data-sal-delay="600" data-sal-duration="800"><span
                                            class="ext">.com</span> only $6.19</li>
                                    <li data-sal="slide-down" data-sal-delay="700" data-sal-duration="800"><span
                                            class="ext">.net</span> only $6.19</li>
                                    <li data-sal="slide-down" data-sal-delay="800" data-sal-duration="800"><span
                                            class="ext">.info</span> only $6.19</li>
                                    <li data-sal="slide-down" data-sal-delay="900" data-sal-duration="800"><span
                                            class="ext">.org</span> only $6.19</li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SEARCH DOMAIN END -->


    <!-- ABOUT US -->
    <div class="rts-about wp__hosting__option position-relative section__padding">
        <div class="container">
            <div class="row">
                <div class="col-xl-6 col-lg-6">
                    <div class="rts-about__image">
                        <img src="assets/images/about/about-big.png" alt="">
                        <img src="assets/images/about/about-shape-01.svg" alt="" class="shape one right-left">
                        <img src="assets/images/about/about-shape-02.svg" alt="" class="shape two">
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6">
                    <div class="rts-about__content">
                        <h3 data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">We build Our Business
                            For Your Success.
                        </h3>
                        <p class="description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                            Whether you need a simple blog, want to highlight your
                            business, sell products through an eCommerce.
                        </p>
                        <div class="rts-about__content--single" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                            <div class="image">

                                <img src="assets/images/about/01.svg" alt="">
                            </div>
                            <div class="description">
                                <h6>Web Hosting</h6>
                                <p>The most popular hosting plan available and comes at one of the most affordable price
                                    points.</p>
                            </div>
                        </div>
                        <div class="rts-about__content--single" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">
                            <div class="image bg-2">
                                <img src="assets/images/about/02.svg" alt="">
                            </div>
                            <div class="description">
                                <h6>Managed WordPress Hosting</h6>
                                <p>Our Managed WordPress Hosting gives you speed and performance with a full set of features.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="rts-about-shape"></div>
    </div>
    <!-- ABOUT US END -->

    <!-- HOSTING PLAN -->
    <section class="rts-plan wp__hosting__option section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section text-center w-560">
                    <h3 class="rts-section__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                        Choose Your Web Hosting Plan</h3>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">Shared hosting is the easiest, most economical way to get your website
                        connected to the Internet so you can start building it.
                    </p>
                </div>
            </div>
            <!-- PLAN -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="rts-plan__table">
                        <table class="table-bordered">
                            <!-- thead -->
                            <thead>
                                <tr>
                                    <th class="package__left">
                                        <img src="assets/images/pricing/pricing-image.svg" alt="">
                                    </th>
                                    <!-- package one -->
                                    <th class="package__item">
                                        <div class="package__item__info">
                                            <span class="package__type">Basic</span>
                                            <span class="start">Starting at $3.75/mo*</span>
                                            <form action="#">
                                                <select name="select" id="select" class="price__select">
                                                    <option value="1">$3.75/mo</option>
                                                    <option value="1">$10.75/mo</option>
                                                </select>
                                                <button type="submit" class="primary__btn primary__bg buy__now">By
                                                    Now</button>
                                            </form>
                                        </div>
                                    </th>
                                    <!-- top-right-corner -->
                                    <th class="package__item">
                                        <!-- table-title-3 -->
                                        <div class="package__item__info">
                                            <span class="package__type">Deluxe</span>
                                            <span class="start">Starting at $3.75/mo*</span>
                                            <form action="#">
                                                <select name="select" id="select1" class="price__select">
                                                    <option value="1">$3.75/mo</option>
                                                    <option value="1">$10.75/mo</option>
                                                </select>
                                                <button type="submit" class="primary__btn primary__bg buy__now">By
                                                    Now</button>
                                            </form>
                                        </div>
                                    </th>
                                    <!-- top-right-corner -->
                                    <th class="package__item">
                                        <div class="package__item__info">
                                            <span class="package__type">Ultra</span>
                                            <span class="start">Starting at $3.75/mo*</span>
                                            <form action="#">
                                                <select name="select" id="select2" class="price__select">
                                                    <option value="1">$3.75/mo</option>
                                                    <option value="1">$10.75/mo</option>
                                                </select>
                                                <button type="submit" class="primary__btn primary__bg buy__now">By
                                                    Now</button>
                                            </form>
                                        </div>
                                    </th>
                                </tr>
                            </thead>
                            <!-- tbody -->
                            <tbody>
                                <!-- hardware -->
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">Websites</td>
                                    <td class="package__item">1</td>
                                    <td class="package__item">Unlimited</td>
                                    <td class="package__item">Unlimited</td>
                                </tr>
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">Disk storage</td>
                                    <td class="package__item">Unlimited</td>
                                    <td class="package__item">Unlimited</td>
                                    <td class="package__item">Unlimited</td>
                                </tr>
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">Bandwidth</td>
                                    <td class="package__item">Scaleable</td>
                                    <td class="package__item">Scaleable</td>
                                    <td class="package__item">Scaleable</td>
                                </tr>
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">FTP users</td>
                                    <td class="package__item">6</td>
                                    <td class="package__item">27</td>
                                    <td class="package__item">Unlimited</td>
                                </tr>
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">MySQL databases</td>
                                    <td class="package__item">10</td>
                                    <td class="package__item">27</td>
                                    <td class="package__item">Unlimited</td>
                                </tr>
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">Free SSl certificate</td>
                                    <td class="package__item"><i class="fa-regular fa-check"></i></td>
                                    <td class="package__item"><i class="fa-regular fa-check"></i></td>
                                    <td class="package__item"><i class="fa-regular fa-check"></i></td>
                                </tr>
                                <tr data-filter="hardware" class="">
                                    <td class="package__left">Free Domain for the first year</td>
                                    <td class="package__item"><i class="fa-regular fa-check"></i></td>
                                    <td class="package__item"><i class="fa-regular fa-check"></i></td>
                                    <td class="package__item"><i class="fa-regular fa-check"></i></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HOSTING PLAN END -->

    <!-- TESTIMONIAL -->
    <section class="rts-testimonial wp__hosting__option section__padding">
        <div class="container">
            <div class="row ">
                <div class="col-12 d-flex justify-content-center">
                    <div class="rts-section w-460 text-center">
                        <h3 class="rts-section__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Our Customers Love Us</h3>
                        <p class="rts-section__description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">From 24/7 support that acts as your extended team to incredibly fast
                            website performance</p>
                    </div>
                </div>
            </div>
            <!-- testimonial -->
            <div class="row">
                <div class="col-lg-12">
                    <div class="rts-testimonial__slider testimonial__slider--first">
                        <div class="swiper-wrapper">
                            <!-- single testimonial -->
                            <div class="swiper-slide">
                                <div class="rts-testimonial__single">
                                    <div class="rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                    <div class="content">
                                        <p>Excellent option for those looking for High-End WordPress Hosting. I have
                                            been using Cloud ways.</p>
                                    </div>
                                    <div class="author__meta">
                                        <div class="author__meta--image">
                                            <img src="assets/images/testimonials/author.png" alt="">
                                        </div>
                                        <div class="author__meta--details">
                                            <a href="#">Jamie Knop</a>
                                            <span>Business Owner</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- single testimonial end -->
                            <!-- single testimonial -->
                            <div class="swiper-slide">
                                <div class="rts-testimonial__single">
                                    <div class="rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                    <div class="content">
                                        <p>Excellent option for those looking for High-End WordPress Hosting. I have
                                            been using Cloud ways.</p>
                                    </div>
                                    <div class="author__meta">
                                        <div class="author__meta--image">
                                            <img src="assets/images/testimonials/author-2.png" alt="">
                                        </div>
                                        <div class="author__meta--details">
                                            <a href="#">Jahed Khan</a>
                                            <span>Business Owner</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- single testimonial end -->
                            <!-- single testimonial -->
                            <div class="swiper-slide">
                                <div class="rts-testimonial__single">
                                    <div class="rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                    <div class="content">
                                        <p>Excellent option for those looking for High-End WordPress Hosting. I have
                                            been using Cloud ways.</p>
                                    </div>
                                    <div class="author__meta">
                                        <div class="author__meta--image">
                                            <img src="assets/images/testimonials/author-3.png" alt="">
                                        </div>
                                        <div class="author__meta--details">
                                            <a href="#">Samira Khan</a>
                                            <span>Digital Marketer</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- single testimonial end -->
                            <!-- single testimonial -->
                            <div class="swiper-slide">
                                <div class="rts-testimonial__single">
                                    <div class="rating">
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                        <i class="fa-solid fa-star"></i>
                                    </div>
                                    <div class="content">
                                        <p>Excellent option for those looking for High-End WordPress Hosting. I have
                                            been using Cloud ways.</p>
                                    </div>
                                    <div class="author__meta">
                                        <div class="author__meta--image">
                                            <img src="assets/images/testimonials/author.png" alt="">
                                        </div>
                                        <div class="author__meta--details">
                                            <a href="#">Jamie Knop</a>
                                            <span>Business Owner</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- single testimonial end -->
                        </div>
                        <!-- pagination dot -->
                        <div class="rts-dot__button slider-center"></div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- TESTIMONIAL END -->

    <!-- FAQ -->
    <section class="rts-faq section__padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-5">
                    <div class="rts-faq__first">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Got
                            questions? Well,
                            we've got answers.</h3>
                        <p data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">From 24/7 support that
                            acts as your extended team to incredibly fast website performance</p>
                        <img data-sal="slide-down" data-sal-delay="500" data-sal-duration="800" src="assets/images/faq/faq.svg" alt="faq">
                        <div class="rts-faq__first--shape">
                            <div class="img"><img src="assets/images/faq/faq__animated.svg" alt=""></div>
                            <div class="shape-one">domain</div>
                            <div class="shape-two">hosting</div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 offset-lg-1">
                    <div class="rts-faq__accordion">
                        <div class="accordion accordion-flush" id="rts-accordion">
                            <div class="accordion-item active" data-sal="slide-left" data-sal-delay="300" data-sal-duration="800">
                                <div class="accordion-header" id="first">
                                    <h4 class="accordion-button collapse show" data-bs-toggle="collapse" data-bs-target="#item__one" aria-expanded="false" aria-controls="item__one">
                                        Why buy a domain name from hostie?
                                    </h4>
                                </div>
                                <div id="item__one" class="accordion-collapse collapse collapse show" aria-labelledby="first" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you
                                        buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                                <div class="accordion-header" id="two">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__two" aria-expanded="false" aria-controls="item__two">
                                        How does domain registration work?
                                    </h4>
                                </div>
                                <div id="item__two" class="accordion-collapse collapse" aria-labelledby="two" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you
                                        buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>
                            <div class="accordion-item" data-sal="slide-left" data-sal-delay="500" data-sal-duration="800">
                                <div class="accordion-header" id="three">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__three" aria-expanded="false" aria-controls="item__three">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__three" class="accordion-collapse collapse" aria-labelledby="three" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you
                                        buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                            <div class="accordion-item" data-sal="slide-left" data-sal-delay="600" data-sal-duration="800">
                                <div class="accordion-header" id="four">
                                    <h4 class="accordion-button collapsed" data-bs-toggle="collapse" data-bs-target="#item__four" aria-expanded="false" aria-controls="item__four">
                                        Why is domain name registration required?
                                    </h4>
                                </div>
                                <div id="item__four" class="accordion-collapse collapse" aria-labelledby="four" data-bs-parent="#rts-accordion">
                                    <div class="accordion-body">
                                        Above all else, we strive to deliver outstanding customer experiences. When you
                                        buy a domain name from hostie, we guarantee it will be handed over.
                                    </div>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- FAQ END -->

    <!-- CONTACT FORM -->
    <div class="rts-contact">
        <div class="container">
            <div class="row ">
                <div class="col-12 d-flex justify-content-center">
                    <div class="rts-section w-460 text-center">
                        <h3 class="rts-section__title" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">Request a consultation.</h3>
                        <p class="rts-section__description" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">From 24/7 support that acts as your extended team to incredibly fast
                            website performance</p>
                    </div>
                </div>
            </div>
            <!-- contact form -->

            <div class="row justify-content-md-center align-items-center g-5">
                <div class="col-lg-6 col-md-10">
                    <form action="#" class="contact__form">
                        <div class="row g-5">
                            <div class="col-lg-6 col-md-6">
                                <label for="fname" class="contact__form__label">First Name *</label>
                                <input class="contact__form__input" type="text" placeholder="First Name" name="fname" required>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <label for="lname" class="contact__form__label">Last Name *</label>
                                <input class="contact__form__input" type="text" placeholder="Last Name" name="lname" required>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <label for="email" class="contact__form__label">Email Address *</label>
                                <input class="contact__form__input" type="email" placeholder="Enter your email" name="email" required>
                            </div>
                            <div class="col-lg-6 col-md-6">
                                <label for="Subject" class="contact__form__label">Enter Your Subject</label>
                                <input class="contact__form__input" type="text" placeholder="Enter your Subject" name="Subject" required>
                            </div>
                            <div class="col-lg-12">
                                <label for="msg" class="contact__form__label">Enter Your Message</label>
                                <textarea class="contact__form__textarea" type="text" placeholder="Enter your Message" name="msg" required></textarea>
                                <button type="submit" class="contact__form__submit mt--40">Send Your Message</button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-lg-6 col-md-10">
                    <div class="map__area">
                        <iframe src="https://maps.google.com/maps?width=100%25&amp;height=600&amp;hl=en&amp;q=Reacthemes+(Reactheme)&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <!-- CONTACT FORM END -->

    <!-- FOOTER AREA START-->
        <?php include 'layout/footer/footer-one.php';?>
    <!-- FOOTER AREA END -->

    <div id="anywhere-home" class=""></div>

    <!-- Sidebar area start -->
        <?php include 'layout/partials/sidebar.php';?>
    <!-- Sidebar area end -->

    <!-- THEME PRELOADER START -->
        <?php include 'layout/partials/preloader.php';?>
    <!-- THEME PRELOADER END -->

    <!-- BACK TO TOP AREA START -->
        <?php include 'layout/partials/back-to-top.php';?>
    <!-- BACK TO TOP AREA EDN -->

    <!-- Scripts -->
        <?php include 'layout/partials/scripts.php';?>
</body>

</html>