<!DOCTYPE html>
<html lang="en">

<!-- head area start -->
    <?php include 'layout/partials/head.php';?>
<!-- head area end -->

<body>
    <!-- HEADER AREA -->
        <?php include 'layout/header/header-three.php';?>
    <!-- HEADER AREA END -->

    <!-- HERO BANNER four -->
    <section class="rts-hero-four rts-hero__four" style="background-image: url(assets/images/banner/banner-hero-four.png);">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 col-xl-6 col-md-10">
                    <div class="rts-hero-four__content" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                        <p class="offer">Up to <span class="off">78%</span> off Web Hosting</p>
                        <h1 class="banner__title" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                            Your Perfect Domain
                            Hosting Solution
                        </h1>
                        <p class="description" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">Welcome to our domain hosting platform your online journey
                            begins. We offer reliable and secure hosting.
                        </p>
                        <div class="feature" data-sal="slide-down" data-sal-delay="700" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">24/7 Customer Support</li>
                                <li class="feature__item">Free Domain</li>
                                <li class="feature__item">Free Website Migration</li>
                            </ul>
                        </div>
                        <div class="banner-buttons" data-sal="slide-down" data-sal-delay="800" data-sal-duration="800">
                            <a href="pricing.php" class="rts-btn btn__long secondary__bg secondary__color">get started <i class="fa-solid fa-chevron-right"></i></a>
                            <a href="contact.php" class="rts-btn btn__long border__white white__color">contact us <i class="fa-solid fa-chevron-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- HERO BANNER four END -->

    <!-- DOMAIN CHECKER -->
    <div class="rts-domain-checker-two section__padding">
        <div class="container">
            <div class="row">
                <div class="rts-hero__content">
                    <h1 data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Find Your Domain Name
                    </h1>
                    <p class="description" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Web Hosting, Domain Name and Hosting Center Solutions</p>
                    <form action="https://hostie-whmcs.themewant.com/cart.php">
                        <div class="rts-hero__form-area">
                            <input type="hidden" name="domain" value="register">
                            <input type="hidden" name="a" value="add">
                            <input type="text" placeholder="find your domain name" name="query" required>
                            <div class="select-button-area">
                                <select name="domain_type" id="select" class="price__select">
                                    <option value=".com">.com</option>
                                    <option value=".net">.net</option>
                                    <option value=".love">.love</option>
                                    <option value=".pw">.pw</option>
                                    <option value=".org">.org</option>
                                    <option value=".org">.org</option>
                                    <option value=".info">.info</option>
                                    <option value=".info">.info</option>
                                    <option value=".xyz">.xyz</option>
                                </select>
                                <button type="submit">Search</button>
                            </div>
                        </div>
                    </form>
                    <div class="banner-content-tag">
                        <p class="desc">Popular Domain:</p>
                        <ul class="tag-list">
                            <li><span>.com</span><span>$6.19</span></li>
                            <li><span>.net</span><span>$6.19</span></li>
                            <li><span>.org</span><span>$6.19</span></li>
                            <li><span>.info</span><span>$6.19</span></li>
                            <li><span>.xyz</span><span>$6.19</span></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- DOMAIN CHECKER END -->

    <!-- HOSTING FEATURE FOUR -->
    <div class="rts-hosting-feature-four pb-120">
        <div class="container">
            <div class="row">
                <div class="rts-section section-style-two">
                    <div class="rts-section__two">
                        <h2 class="title mb-0" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Explore Our Web
                            Hosting Features</h2>
                    </div>
                    <div class="rts-section-description w-550">
                        <p class="description" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">
                            We take pride in providing you with a hosting experience that goes
                            beyond the ordinary. Our hosting packages are packed array of
                            powerful features to ensure your website's success.
                        </p>
                        <a href="pricing.php">View all feature <i class="fa-solid fa-chevron-right"></i></a>
                    </div>
                </div>
            </div>
            <!-- feature lsit -->
            <div class="row g-30">
                <div class="col-lg-3 col-sm-6" data-sal="slide-down" data-sal-delay="400" data-sal-duration="800">
                    <div class="feature__single">
                        <div class="feature__single--icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M6.25 35H18.75C19.0815 35 19.3995 34.8683 19.6339 34.6339C19.8683 34.3995 20 34.0815 20 33.75C20 33.4185 19.8683 33.1005 19.6339 32.8661C19.3995 32.6317 19.0815 32.5 18.75 32.5H6.25C5.91848 32.5 5.60054 32.3683 5.36612 32.1339C5.1317 31.8995 5 31.5815 5 31.25V25H18.75C19.0815 25 19.3995 24.8683 19.6339 24.6339C19.8683 24.3995 20 24.0815 20 23.75C20 23.4185 19.8683 23.1005 19.6339 22.8661C19.3995 22.6317 19.0815 22.5 18.75 22.5H5V15H33.75C34.0815 15 34.3995 14.8683 34.6339 14.6339C34.8683 14.3995 35 14.0815 35 13.75V6.25C35 5.25544 34.6049 4.30161 33.9017 3.59835C33.1984 2.89509 32.2446 2.5 31.25 2.5H6.25C5.25544 2.5 4.30161 2.89509 3.59835 3.59835C2.89509 4.30161 2.5 5.25544 2.5 6.25V31.25C2.5 32.2446 2.89509 33.1984 3.59835 33.9017C4.30161 34.6049 5.25544 35 6.25 35ZM5 6.25C5 5.91848 5.1317 5.60054 5.36612 5.36612C5.60054 5.1317 5.91848 5 6.25 5H31.25C31.5815 5 31.8995 5.1317 32.1339 5.36612C32.3683 5.60054 32.5 5.91848 32.5 6.25V12.5H5V6.25Z" fill="#2D3C58" />
                                <path d="M6.61252 9.10004C6.38117 9.34273 6.25146 9.66475 6.25002 10C6.24907 10.1646 6.2806 10.3276 6.34281 10.4799C6.40501 10.6322 6.49667 10.7707 6.61252 10.8875C6.72872 11.0047 6.86698 11.0977 7.0193 11.1612C7.17162 11.2246 7.33501 11.2573 7.50002 11.2573C7.66504 11.2573 7.82842 11.2246 7.98074 11.1612C8.13307 11.0977 8.27132 11.0047 8.38752 10.8875C8.62456 10.6522 8.75838 10.3323 8.75955 9.99821C8.76073 9.66416 8.62915 9.34333 8.39377 9.10629C8.15839 8.86926 7.83849 8.73543 7.50444 8.73426C7.17039 8.73309 6.84956 8.86467 6.61252 9.10004Z" fill="#2D3C58" />
                                <path d="M10.3625 9.09997C10.1312 9.34266 10.0015 9.66468 10 9.99997C9.99907 10.1645 10.0306 10.3276 10.0928 10.4799C10.155 10.6322 10.2467 10.7707 10.3625 10.8875C10.5996 11.1229 10.9204 11.2544 11.2544 11.2533C11.5885 11.2521 11.9084 11.1183 12.1438 10.8812C12.3792 10.6442 12.5107 10.3234 12.5096 9.9893C12.5084 9.65525 12.3746 9.33535 12.1375 9.09997C12.0213 8.98281 11.8831 8.88982 11.7307 8.82636C11.5784 8.7629 11.415 8.73022 11.25 8.73022C11.085 8.73022 10.9216 8.7629 10.7693 8.82636C10.617 8.88982 10.4787 8.98281 10.3625 9.09997Z" fill="#2D3C58" />
                                <path d="M6.61252 19.1125C6.3841 19.352 6.25463 19.669 6.25002 20C6.24907 20.1645 6.2806 20.3276 6.34281 20.4799C6.40501 20.6322 6.49667 20.7707 6.61252 20.8875C6.72872 21.0046 6.86698 21.0976 7.0193 21.1611C7.17162 21.2246 7.33501 21.2572 7.50002 21.2572C7.66504 21.2572 7.82842 21.2246 7.98074 21.1611C8.13307 21.0976 8.27132 21.0046 8.38752 20.8875C8.6229 20.6521 8.75514 20.3329 8.75514 20C8.75514 19.6671 8.6229 19.3479 8.38752 19.1125C8.15214 18.8771 7.8329 18.7449 7.50002 18.7449C7.16714 18.7449 6.8479 18.8771 6.61252 19.1125Z" fill="#2D3C58" />
                                <path d="M10.3625 19.1125C10.1341 19.352 10.0046 19.669 10 20C9.99907 20.1645 10.0306 20.3276 10.0928 20.4799C10.155 20.6322 10.2467 20.7707 10.3625 20.8875C10.5377 21.0613 10.7605 21.1793 11.0027 21.2267C11.2449 21.2741 11.4957 21.2488 11.7235 21.1539C11.9513 21.059 12.1459 20.8987 12.2828 20.6934C12.4197 20.4881 12.4928 20.2468 12.4928 20C12.4928 19.7532 12.4197 19.5119 12.2828 19.3066C12.1459 19.1013 11.9513 18.941 11.7235 18.8461C11.4957 18.7512 11.2449 18.7259 11.0027 18.7733C10.7605 18.8207 10.5377 18.9387 10.3625 19.1125Z" fill="#2D3C58" />
                                <path d="M6.61252 29.1C6.38117 29.3427 6.25146 29.6647 6.25002 30C6.24907 30.1645 6.2806 30.3276 6.34281 30.4799C6.40501 30.6322 6.49667 30.7707 6.61252 30.8875C6.72872 31.0046 6.86698 31.0976 7.0193 31.1611C7.17162 31.2246 7.33501 31.2572 7.50002 31.2572C7.66504 31.2572 7.82842 31.2246 7.98074 31.1611C8.13307 31.0976 8.27132 31.0046 8.38752 30.8875C8.6229 30.6521 8.75514 30.3329 8.75514 30C8.75514 29.6671 8.6229 29.3479 8.38752 29.1125C8.15214 28.8771 7.8329 28.7449 7.50002 28.7449C7.16714 28.7449 6.8479 28.8771 6.61252 29.1125V29.1Z" fill="#2D3C58" />
                                <path d="M10.3625 29.1C10.1312 29.3427 10.0015 29.6647 10 30C9.99907 30.1645 10.0306 30.3276 10.0928 30.4799C10.155 30.6322 10.2467 30.7707 10.3625 30.8875C10.5377 31.0613 10.7605 31.1793 11.0027 31.2267C11.2449 31.2741 11.4957 31.2488 11.7235 31.1539C11.9513 31.059 12.1459 30.8987 12.2828 30.6934C12.4197 30.4881 12.4928 30.2468 12.4928 30C12.4928 29.7532 12.4197 29.5119 12.2828 29.3066C12.1459 29.1013 11.9513 28.941 11.7235 28.8461C11.4957 28.7512 11.2449 28.7259 11.0027 28.7733C10.7605 28.8207 10.5377 28.9387 10.3625 29.1125V29.1Z" fill="#2D3C58" />
                                <path d="M35.25 22.3V21.25C35.2467 19.726 34.6398 18.2654 33.5622 17.1878C32.4846 16.1102 31.024 15.5033 29.5 15.5C27.975 15.5 26.5125 16.1058 25.4341 17.1841C24.3558 18.2625 23.75 19.725 23.75 21.25V22.3C23.1188 22.4167 22.5483 22.7505 22.1374 23.2437C21.7265 23.7368 21.501 24.3581 21.5 25V34.75C21.5033 35.4783 21.7941 36.1759 22.3091 36.6909C22.8241 37.2059 23.5217 37.4967 24.25 37.5H34.75C35.4783 37.4967 36.1759 37.2059 36.6909 36.6909C37.2059 36.1759 37.4967 35.4783 37.5 34.75V25C37.499 24.3581 37.2735 23.7368 36.8626 23.2437C36.4517 22.7505 35.8812 22.4167 35.25 22.3ZM29.5 18C30.3609 18.0033 31.1857 18.3468 31.7945 18.9555C32.4032 19.5643 32.7467 20.3891 32.75 21.25V22.25H26.25V21.25C26.2533 20.3891 26.5968 19.5643 27.2055 18.9555C27.8143 18.3468 28.6391 18.0033 29.5 18ZM35 34.75C35 34.8163 34.9737 34.8799 34.9268 34.9268C34.8799 34.9737 34.8163 35 34.75 35H24.25C24.1837 35 24.1201 34.9737 24.0732 34.9268C24.0263 34.8799 24 34.8163 24 34.75V25C24 24.9337 24.0263 24.8701 24.0732 24.8232C24.1201 24.7763 24.1837 24.75 24.25 24.75H34.75C34.8163 24.75 34.8799 24.7763 34.9268 24.8232C34.9737 24.8701 35 24.9337 35 25V34.75Z" fill="#2D3C58" />
                            </svg>
                        </div>
                        <a href="faq.php" class="feature__single--title">Passion for Privacy</a>
                        <p class="feature__single--description">We believe in everyone's right to
                            privacy & we back policy
                        </p>
                        <div class="feature__single--btn">
                            <a href="faq.php" class="round__btn"><i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6" data-sal="slide-down" data-sal-delay="500" data-sal-duration="800">
                    <div class="feature__single">
                        <div class="feature__single--icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <g clip-path="url(#clip0_332_2437)">
                                    <path d="M37.6562 19.1595V14.4436C37.6562 12.1268 35.8127 10.2334 33.5156 10.1507V7.25614C33.5156 5.7484 32.289 4.52176 30.7812 4.52176H23.2533L22.2812 1.81965C22.0333 1.13059 21.5316 0.579965 20.8684 0.269261C20.2053 -0.0415198 19.4611 -0.0746448 18.773 0.175824L5.1125 5.14778C4.42516 5.39793 3.8768 5.90098 3.56836 6.56426C3.25992 7.22754 3.22859 7.97106 3.48023 8.65793L4.02906 10.156C1.78414 10.2948 0 12.1643 0 14.4436V35.6936C0 38.0629 1.92758 39.9905 4.29688 39.9905H33.3594C35.7287 39.9905 37.6562 38.0629 37.6562 35.6936V30.8215C38.9795 30.6314 40 29.4906 40 28.1155V21.8655C40 20.4904 38.9795 19.3497 37.6562 19.1595ZM37.6562 28.1155C37.6562 28.3309 37.481 28.5061 37.2656 28.5061H31.0156C29.0771 28.5061 27.5 26.929 27.5 24.9905C27.5 23.052 29.0771 21.4749 31.0156 21.4749H37.2656C37.481 21.4749 37.6562 21.6501 37.6562 21.8655V28.1155ZM5.68094 7.85168C5.63242 7.71926 5.66797 7.60746 5.69352 7.55254C5.71906 7.4977 5.78164 7.3984 5.91414 7.3502L19.5746 2.37825C19.7073 2.33004 19.8191 2.3659 19.874 2.39161C19.9289 2.41731 20.028 2.48028 20.0758 2.61309L20.7625 4.52184H20.2344C18.7266 4.52184 17.5 5.74848 17.5 7.25621V10.1468H6.5218L5.68094 7.85168ZM31.1719 7.25614V10.1468H19.8438V7.25614C19.8438 7.04075 20.019 6.86551 20.2344 6.86551H30.7812C30.9966 6.86551 31.1719 7.04075 31.1719 7.25614ZM33.3594 37.6468H4.29688C3.21992 37.6468 2.34375 36.7706 2.34375 35.6936V14.4436C2.34375 13.3667 3.21992 12.4905 4.29688 12.4905H33.3594C34.4363 12.4905 35.3125 13.3667 35.3125 14.4436V19.1311H31.0156C27.7848 19.1311 25.1562 21.7597 25.1562 24.9905C25.1562 28.2214 27.7848 30.8499 31.0156 30.8499H35.3125V35.6936C35.3125 36.7706 34.4363 37.6468 33.3594 37.6468Z" fill="#2D3C58" />
                                    <path d="M31.0156 26.1625C31.6628 26.1625 32.1875 25.6378 32.1875 24.9906C32.1875 24.3434 31.6628 23.8187 31.0156 23.8187C30.3684 23.8187 29.8438 24.3434 29.8438 24.9906C29.8438 25.6378 30.3684 26.1625 31.0156 26.1625Z" fill="#2D3C58" />
                                </g>
                                <defs>
                                    <clipPath id="clip0_332_2437">
                                        <rect width="40" height="40" fill="white" />
                                    </clipPath>
                                </defs>
                            </svg>
                        </div>
                        <a href="faq.php" class="feature__single--title">Money-Back Guaranteed</a>
                        <p class="feature__single--description">We believe in everyone's right to
                            privacy & we back policy
                        </p>
                        <div class="feature__single--btn">
                            <a href="faq.php" class="round__btn"><i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">
                    <div class="feature__single">
                        <div class="feature__single--icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M3.77599 0.159466C3.77701 0.159822 3.77805 0.16018 3.77907 0.160536L38.0902 12.0366C38.0909 12.0369 38.0917 12.0373 38.0925 12.0374C40.7087 12.9357 40.5929 16.6231 37.9963 17.4302L22.4859 22.2151C22.4698 22.2201 22.4538 22.2246 22.4377 22.2288C22.3866 22.2425 22.3399 22.2689 22.3023 22.3059C22.2647 22.3428 22.2373 22.3889 22.2228 22.4397L22.2152 22.4651L17.4302 37.9963C16.6231 40.5929 12.9357 40.7087 12.0374 38.0925C12.0373 38.0917 12.0369 38.0909 12.0366 38.0902L0.160536 3.77907C0.16018 3.77805 0.159822 3.77701 0.159466 3.77599C-0.0169322 3.27222 -0.0476967 2.72892 0.0707236 2.20842C0.189387 1.68686 0.453019 1.20947 0.831244 0.831244C1.20947 0.453019 1.68686 0.189387 2.20842 0.0707236C2.72892 -0.0476967 3.27222 -0.0169322 3.77599 0.159466ZM1.30805 3.37579L2.45745 2.97794L14.3367 37.2983L14.338 37.302C14.3766 37.4147 14.4324 37.4709 14.4834 37.5043C14.5424 37.5429 14.6246 37.569 14.7195 37.567C14.8144 37.5653 14.8984 37.5359 14.9598 37.4924C15.0137 37.4543 15.0703 37.3924 15.1069 37.2751C15.1069 37.2753 15.1071 37.2748 15.1069 37.2751L19.8872 21.7597C20.0182 21.3085 20.2631 20.8985 20.5987 20.5695C20.931 20.2435 21.3408 20.0077 21.7892 19.8843L37.2743 15.1072C37.274 15.1072 37.2745 15.1071 37.2743 15.1072C37.3917 15.0706 37.4543 15.0137 37.4924 14.9598C37.5359 14.8984 37.5653 14.8144 37.567 14.7195C37.569 14.6246 37.5429 14.5424 37.5043 14.4834C37.4709 14.4324 37.4147 14.3766 37.302 14.338L37.2983 14.3367L2.97249 2.45557C2.9004 2.43024 2.82262 2.42578 2.7481 2.44273C2.6736 2.45968 2.60541 2.49735 2.55137 2.55137C2.49735 2.60541 2.45968 2.6736 2.44273 2.7481C2.42578 2.82262 2.43022 2.9004 2.45556 2.97249L1.30805 3.37579Z" fill="#2D3C58" />
                            </svg>
                        </div>
                        <a href="faq.php" class="feature__single--title">super easy to use</a>
                        <p class="feature__single--description">We guarantee it you don't have
                            to worry about it.
                        </p>
                        <div class="feature__single--btn">
                            <a href="faq.php" class="round__btn"><i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
                <div class="col-lg-3 col-sm-6" data-sal="slide-down" data-sal-delay="700" data-sal-duration="800">
                    <div class="feature__single">
                        <div class="feature__single--icon">
                            <svg width="40" height="40" viewBox="0 0 40 40" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M19.8333 0C30.787 0 39.6667 8.87969 39.6667 19.8333C39.6667 30.787 30.787 39.6667 19.8333 39.6667C8.87969 39.6667 0 30.787 0 19.8333C0 8.87969 8.87969 0 19.8333 0ZM19.8333 2.08772C10.0327 2.08772 2.08772 10.0327 2.08772 19.8333C2.08772 29.634 10.0327 37.579 19.8333 37.579C29.634 37.579 37.579 29.634 37.579 19.8333C37.579 10.0327 29.634 2.08772 19.8333 2.08772ZM31.0101 8.65662C31.3864 9.03291 31.4542 9.71168 31.0101 10.1329L23.4307 17.7122C23.798 18.3339 24.0088 19.059 24.0088 19.8333C24.0088 22.1394 22.1394 24.0088 19.8333 24.0088C17.5273 24.0088 15.6579 22.1394 15.6579 19.8333C15.6579 17.5273 17.5273 15.6579 19.8333 15.6579C20.6077 15.6579 21.3328 15.8687 21.9545 16.236L29.5338 8.65662C29.9415 8.24897 30.6024 8.24897 31.0101 8.65662ZM19.8333 17.7456C18.6803 17.7456 17.7456 18.6803 17.7456 19.8333C17.7456 20.9864 18.6803 21.9211 19.8333 21.9211C20.9864 21.9211 21.9211 20.9864 21.9211 19.8333C21.9211 18.6803 20.9864 17.7456 19.8333 17.7456ZM32.1693 14.1715C32.9788 15.9325 33.4035 17.8539 33.4035 19.8333C33.4035 20.4098 32.9362 20.8772 32.3597 20.8772C31.7831 20.8772 31.3158 20.4098 31.3158 19.8333C31.3158 18.1565 30.9568 16.5323 30.2724 15.0435C30.0316 14.5197 30.2611 13.8998 30.7849 13.659C31.3087 13.4183 31.9285 13.6477 32.1693 14.1715ZM19.8333 6.26316C21.831 6.26316 23.7696 6.6958 25.5435 7.51973C26.0664 7.76258 26.2934 8.38331 26.0506 8.90617C25.8077 9.42904 25.187 9.65604 24.6641 9.41319C23.1642 8.71657 21.5257 8.35088 19.8333 8.35088C13.4918 8.35088 8.35088 13.4918 8.35088 19.8333C8.35088 20.4098 7.88353 20.8772 7.30702 20.8772C6.73051 20.8772 6.26316 20.4098 6.26316 19.8333C6.26316 12.3387 12.3387 6.26316 19.8333 6.26316Z" fill="#2D3C58" />
                            </svg>
                        </div>
                        <a href="faq.php" class="feature__single--title">First & Reliable</a>
                        <p class="feature__single--description">We believe in everyone's right to
                            privacy & we back policy
                        </p>
                        <div class="feature__single--btn">
                            <a href="faq.php" class="round__btn"><i class="fa-regular fa-arrow-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- HOSTING FEATURE FOUR END -->

    <!-- PRICING PLAN START -->
    <div class="rts-pricing-plan alice__blue section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section w-500 text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Choose Hosting Plan</h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Globally incubate next-generation e-services via state of the art technology.
                    </p>
                </div>
            </div>
            <div class="row">
                <div class="row justify-content-center">
                    <div class="col-lg-4 col-md-5">
                        <div class="rts-pricing-plan__tab plan__tab">
                            <div class="tab__button">
                                <div class="tab__button__item">
                                    <button class="active tab__price text-white" data-tab="monthly">monthly</button>
                                    <button class="tab__price text-white" data-tab="yearly">yearly</button>
                                </div>
                            </div>
                            <div class="discount">
                                <span class="line"><img src="assets/images/pricing/offer__vactor.svg" height="20" width="85" alt=""></span>
                                <p>20% save</p>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- PRICING PLAN -->
                <div class="price__content open" id="monthly">
                    <div class="row g-30 monthly">
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/basic.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Basic</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$6.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 3.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/premium.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Premium</h4>
                                </div>
                                <p class="card-plan__desc">Level-up more power features</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$12.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 6.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan active">
                                <div class="popular-tag">most popular</div>
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/business.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Business</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$19.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 8.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan ">

                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/cloud.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Cloud Startup</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$29.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 11.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 6.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                    </div>
                </div>

                <!-- PRICING PLAN -->
                <div class="price__content" id="yearly">
                    <div class="row g-30 yearly">
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/basic.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Basic</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$79.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 36.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 79.99 /year when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/premium.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Premium</h4>
                                </div>
                                <p class="card-plan__desc">Level-up more power features</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$151.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 79.56 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 151.99 /year when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan active">
                                <div class="popular-tag">most popular</div>
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/business.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Business</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$235.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 103.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 235.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-xmark"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                        <!-- single card -->
                        <div class="col-lg-3 col-md-6 col-sm-6">
                            <div class="card-plan ">
                                <div class="card-plan__package">
                                    <div class="icon">
                                        <img src="assets/images/pricing/cloud.svg" height="30" width="30" alt="">
                                    </div>
                                    <h4 class="package__name">Cloud Startup</h4>
                                </div>
                                <p class="card-plan__desc">Everything need to your website</p>
                                <div class="card-plan__offer">
                                    <span class="past-price">$353.63</span>
                                    <span class="offer-given">Save 60%</span>
                                </div>
                                <h5 class="card-plan__price">
                                    <sup>$</sup> 139.63 <sub>/ month</sub>
                                </h5>
                                <div class="card-plan__cartbtn">
                                    <a href="#">add to cart</a>
                                </div>
                                <p class="card-plan__renew-price">
                                    $ 353.99 /mo when you renew
                                </p>
                                <div class="card-plan__feature">
                                    <ul class="card-plan__feature--list">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 1 Website</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Explore, discover, and learn on our innovative and informative website."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Standard Performance</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Unlock superior online experiences with our standard performance solutions, ensuring reliability, speed, and seamless functionality for your website needs."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 24/7/365 Support</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides reliable 24/7 support for your hosting needs, ensuring assistance whenever you require help."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Free Email</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers complimentary email services, empowering your online communication with reliable and secure free email solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Bandwidth</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie provides unlimited bandwidth, ensuring seamless data transfer for your website's optimal performance and user experience."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom"
                                            title="Elevate your online presence with Hostie, offering unlimited bandwidth for your domain, ensuring optimal performance and seamless data flow."><i class="fa-light fa-circle-question"></i></span>
                                        </li>


                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">More Features <i class="fa-sharp fa-regular fa-chevron-down"></i>
                                            </span>
                                        </li>
                                    </ul>
                                    <ul class="card-plan__feature--list more__feature">
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 100 GB SSD Storage</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie offers generous hosting with 100GB SSD storage, providing ample space for your data and ensuring high-performance storage solutions."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Unlimited Free SSL</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Secure your website with Hostie's unlimited free SSL certificates, ensuring encrypted and safe online transactions for your users."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> 99.9% Uptime Guarantee</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Hostie guarantees 99% uptime, ensuring your website is consistently available and reliable for visitors around the clock."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-item">
                                            <span class="text"><i class="fa-regular fa-check"></i> Web Application Firewall</span>
                                            <span class="tolltip" data-bs-toggle="tooltip" data-bs-placement="bottom" title="Enhance your website's security with Hostie's Web Application Firewall, protecting against online threats and ensuring a safe online environment."><i class="fa-light fa-circle-question"></i></span>
                                        </li>
                                        <li class="card-plan__feature--list-trigered">
                                            <span class="text">See less Features <i class="fa-sharp fa-regular fa-chevron-up"></i>
                                            </span>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <!-- single card end -->
                    </div>
                </div>
            </div>
            <div class="view-plan-btn">
                <a href="pricing.php" class="btn long-btn">view all plan</a>
            </div>
        </div>
    </div>
    <!-- PRICING PLAN START END -->

    <!-- BEST SERVICE -->
    <section class="rts-service-four section__padding">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section w-480 text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Our Best Services</h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Your first website to Cloud ways from any web host for without breaking your live site hosted.
                    </p>
                </div>
            </div>
            <!-- service area -->
            <div class="row g-40">
                <div class="col-lg-5 col-md-4" data-sal="slide-right" data-sal-delay="300" data-sal-duration="800">
                    <div class="rts-service-four__tab">
                        <div class="single__tab tab__btn active" data-tab="wp">
                            <div class="tab__icon">
                                <svg width="45" height="45" viewBox="0 0 50 50" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M30.4897 10.4806C32.474 10.4806 34.0882 8.86633 34.0882 6.882C34.0882 4.89768 32.474 3.28345 30.4897 3.28345C28.5053 3.28345 26.8911 4.89768 26.8911 6.882C26.8911 8.86633 28.5053 10.4806 30.4897 10.4806ZM30.4897 4.46459C31.8204 4.46459 32.9071 5.55125 32.9071 6.882C32.9071 8.21276 31.8204 9.29941 30.4897 9.29941C29.1589 9.29941 28.0723 8.21276 28.0723 6.882C28.0723 5.55125 29.1589 4.46459 30.4897 4.46459Z" fill="white" />
                                    <path d="M4.59818 18.599L3.5824 19.6148C3.35404 19.8432 3.35404 20.2211 3.5824 20.4495C3.70051 20.5676 3.85012 20.6227 3.99974 20.6227C4.14935 20.6227 4.29896 20.5676 4.41707 20.4495L5.43286 19.4337C5.66121 19.2054 5.66121 18.8274 5.43286 18.599C5.2045 18.3707 4.82654 18.3628 4.59818 18.599Z" fill="white" />
                                    <path d="M7.96098 18.599L6.94519 19.6148C6.71684 19.8432 6.71684 20.2211 6.94519 20.4495C7.06331 20.5676 7.21292 20.6227 7.36253 20.6227C7.51214 20.6227 7.66175 20.5676 7.77987 20.4495L8.79565 19.4337C9.02401 19.2054 9.02401 18.8274 8.79565 18.599C8.5673 18.3707 8.19721 18.3628 7.96098 18.599Z" fill="white" />
                                    <path d="M11.3233 18.599L10.3075 19.6148C10.0791 19.8432 10.0791 20.2211 10.3075 20.4495C10.4256 20.5676 10.5752 20.6227 10.7248 20.6227C10.8744 20.6227 11.0241 20.5676 11.1422 20.4495L12.158 19.4337C12.3863 19.2054 12.3863 18.8274 12.158 18.599C11.9296 18.3707 11.5595 18.3628 11.3233 18.599Z" fill="white" />
                                    <path d="M14.6934 18.599L13.6776 19.6148C13.4493 19.8432 13.4493 20.2211 13.6776 20.4495C13.7957 20.5676 13.9453 20.6227 14.095 20.6227C14.2446 20.6227 14.3942 20.5676 14.5123 20.4495L15.5281 19.4337C15.7564 19.2054 15.7564 18.8274 15.5281 18.599C15.2997 18.3707 14.9218 18.3628 14.6934 18.599Z" fill="white" />
                                    <path d="M18.0562 18.599L17.0404 19.6148C16.8121 19.8432 16.8121 20.2211 17.0404 20.4495C17.1585 20.5676 17.3081 20.6227 17.4577 20.6227C17.6074 20.6227 17.757 20.5676 17.8751 20.4495L18.8909 19.4337C19.1192 19.2054 19.1192 18.8274 18.8909 18.599C18.6625 18.3707 18.2845 18.3628 18.0562 18.599Z" fill="white" />
                                    <path d="M21.4185 18.599L20.4027 19.6148C20.1744 19.8432 20.1744 20.2211 20.4027 20.4495C20.5208 20.5676 20.6704 20.6227 20.82 20.6227C20.9697 20.6227 21.1193 20.5676 21.2374 20.4495L22.2532 19.4337C22.4815 19.2054 22.4815 18.8274 22.2532 18.599C22.0248 18.3707 21.6547 18.3628 21.4185 18.599Z" fill="white" />
                                    <path d="M4.59818 22.4338L3.5824 23.4495C3.35404 23.6779 3.35404 24.0559 3.5824 24.2842C3.70051 24.4023 3.85012 24.4575 3.99974 24.4575C4.14935 24.4575 4.29896 24.4023 4.41707 24.2842L5.43286 23.2684C5.66121 23.0401 5.66121 22.6621 5.43286 22.4338C5.19663 22.1975 4.82654 22.1975 4.59818 22.4338Z" fill="white" />
                                    <path d="M7.96098 22.4338L6.94519 23.4495C6.71684 23.6779 6.71684 24.0559 6.94519 24.2842C7.06331 24.4023 7.21292 24.4574 7.36253 24.4574C7.51214 24.4574 7.66175 24.4023 7.77987 24.2842L8.79565 23.2684C9.02401 23.0401 9.02401 22.6621 8.79565 22.4338C8.5673 22.2054 8.18933 22.1975 7.96098 22.4338Z" fill="white" />
                                    <path d="M11.3233 22.4338L10.3075 23.4495C10.0791 23.6779 10.0791 24.0559 10.3075 24.2842C10.4256 24.4023 10.5752 24.4575 10.7248 24.4575C10.8744 24.4575 11.0241 24.4023 11.1422 24.2842L12.158 23.2684C12.3863 23.0401 12.3863 22.6621 12.158 22.4338C11.9296 22.1975 11.5595 22.1975 11.3233 22.4338Z" fill="white" />
                                    <path d="M14.6934 22.4338L13.6776 23.4495C13.4493 23.6779 13.4493 24.0559 13.6776 24.2842C13.7957 24.4023 13.9453 24.4575 14.095 24.4575C14.2446 24.4575 14.3942 24.4023 14.5123 24.2842L15.5281 23.2684C15.7564 23.0401 15.7564 22.6621 15.5281 22.4338C15.2918 22.1975 14.9218 22.1975 14.6934 22.4338Z" fill="white" />
                                    <path d="M18.0562 22.4338L17.0404 23.4495C16.8121 23.6779 16.8121 24.0559 17.0404 24.2842C17.1585 24.4023 17.3081 24.4574 17.4577 24.4574C17.6074 24.4574 17.757 24.4023 17.8751 24.2842L18.8909 23.2684C19.1192 23.0401 19.1192 22.6621 18.8909 22.4338C18.6625 22.2054 18.2845 22.1975 18.0562 22.4338Z" fill="white" />
                                    <path d="M21.4185 22.4338L20.4027 23.4495C20.1744 23.6779 20.1744 24.0559 20.4027 24.2842C20.5208 24.4023 20.6704 24.4575 20.82 24.4575C20.9697 24.4575 21.1193 24.4023 21.2374 24.2842L22.2532 23.2684C22.4815 23.0401 22.4815 22.6621 22.2532 22.4338C22.0248 22.1975 21.6547 22.1975 21.4185 22.4338Z" fill="white" />
                                    <path d="M4.59872 33.4974L3.58293 34.5132C3.3467 34.7416 3.3467 35.1195 3.58293 35.3479C3.70105 35.466 3.85066 35.5211 4.00027 35.5211C4.14988 35.5211 4.29949 35.466 4.41761 35.3479L5.43339 34.3321C5.66175 34.1038 5.66175 33.7258 5.43339 33.4974C5.20504 33.2691 4.82707 33.2691 4.59872 33.4974Z" fill="white" />
                                    <path d="M7.96098 33.4974L6.94519 34.5132C6.71684 34.7416 6.71684 35.1195 6.94519 35.3479C7.06331 35.466 7.21292 35.5211 7.36253 35.5211C7.51214 35.5211 7.66175 35.466 7.77987 35.3479L8.79565 34.3321C9.02401 34.1038 9.02401 33.7258 8.79565 33.4974C8.5673 33.2691 8.19721 33.2691 7.96098 33.4974Z" fill="white" />
                                    <path d="M11.3233 33.4974L10.3075 34.5132C10.0791 34.7416 10.0791 35.1195 10.3075 35.3479C10.4256 35.466 10.5752 35.5211 10.7248 35.5211C10.8744 35.5211 11.0241 35.466 11.1422 35.3479L12.158 34.3321C12.3863 34.1038 12.3863 33.7258 12.158 33.4974C11.9296 33.2691 11.5595 33.2691 11.3233 33.4974Z" fill="white" />
                                    <path d="M14.6934 33.4974L13.6776 34.5132C13.4493 34.7416 13.4493 35.1195 13.6776 35.3479C13.7957 35.466 13.9453 35.5211 14.095 35.5211C14.2446 35.5211 14.3942 35.466 14.5123 35.3479L15.5281 34.3321C15.7564 34.1038 15.7564 33.7258 15.5281 33.4974C15.2997 33.2691 14.9218 33.2691 14.6934 33.4974Z" fill="white" />
                                    <path d="M18.0562 33.4974L17.0404 34.5132C16.8121 34.7416 16.8121 35.1195 17.0404 35.3479C17.1585 35.466 17.3081 35.5211 17.4577 35.5211C17.6074 35.5211 17.757 35.466 17.8751 35.3479L18.8909 34.3321C19.1192 34.1038 19.1192 33.7258 18.8909 33.4974C18.6625 33.2691 18.2845 33.2691 18.0562 33.4974Z" fill="white" />
                                    <path d="M21.4185 33.4974L20.4027 34.5132C20.1744 34.7416 20.1744 35.1195 20.4027 35.3479C20.5208 35.466 20.6704 35.5211 20.82 35.5211C20.9697 35.5211 21.1193 35.466 21.2374 35.3479L22.2532 34.3321C22.4815 34.1038 22.4815 33.7258 22.2532 33.4974C22.0248 33.2691 21.6547 33.2691 21.4185 33.4974Z" fill="white" />
                                    <path d="M4.59818 37.3319L3.5824 38.3477C3.35404 38.5761 3.35404 38.954 3.5824 39.1824C3.70051 39.3005 3.85012 39.3556 3.99974 39.3556C4.14935 39.3556 4.29896 39.3005 4.41707 39.1824L5.43286 38.1666C5.66121 37.9382 5.66121 37.5603 5.43286 37.3319C5.2045 37.1036 4.82654 37.1036 4.59818 37.3319Z" fill="white" />
                                    <path d="M7.96098 37.3319L6.94519 38.3477C6.71684 38.5761 6.71684 38.954 6.94519 39.1824C7.06331 39.3005 7.21292 39.3556 7.36253 39.3556C7.51214 39.3556 7.66175 39.3005 7.77987 39.1824L8.79565 38.1666C9.02401 37.9382 9.02401 37.5603 8.79565 37.3319C8.5673 37.1036 8.19721 37.1036 7.96098 37.3319Z" fill="white" />
                                    <path d="M11.3233 37.3319L10.3075 38.3477C10.0791 38.5761 10.0791 38.954 10.3075 39.1824C10.4256 39.3005 10.5752 39.3556 10.7248 39.3556C10.8744 39.3556 11.0241 39.3005 11.1422 39.1824L12.158 38.1666C12.3863 37.9382 12.3863 37.5603 12.158 37.3319C11.9296 37.1036 11.5595 37.1036 11.3233 37.3319Z" fill="white" />
                                    <path d="M14.6934 37.3319L13.6776 38.3477C13.4493 38.5761 13.4493 38.954 13.6776 39.1824C13.7957 39.3005 13.9453 39.3556 14.095 39.3556C14.2446 39.3556 14.3942 39.3005 14.5123 39.1824L15.5281 38.1666C15.7564 37.9382 15.7564 37.5603 15.5281 37.3319C15.2997 37.1036 14.9218 37.1036 14.6934 37.3319Z" fill="white" />
                                    <path d="M18.0562 37.3319L17.0404 38.3477C16.8121 38.5761 16.8121 38.954 17.0404 39.1824C17.1585 39.3005 17.3081 39.3556 17.4577 39.3556C17.6074 39.3556 17.757 39.3005 17.8751 39.1824L18.8909 38.1666C19.1192 37.9382 19.1192 37.5603 18.8909 37.3319C18.6625 37.1036 18.2845 37.1036 18.0562 37.3319Z" fill="white" />
                                    <path d="M21.4185 37.3319L20.4027 38.3477C20.1744 38.5761 20.1744 38.954 20.4027 39.1824C20.5208 39.3005 20.6704 39.3556 20.82 39.3556C20.9697 39.3556 21.1193 39.3005 21.2374 39.1824L22.2532 38.1666C22.4815 37.9382 22.4815 37.5603 22.2532 37.3319C22.0248 37.1036 21.6547 37.1036 21.4185 37.3319Z" fill="white" />
                                    <path d="M3.99974 5.72475C4.14935 5.72475 4.29896 5.66963 4.41707 5.55151L5.43286 4.53573C5.66121 4.30737 5.66121 3.92941 5.43286 3.70105C5.2045 3.4727 4.82654 3.4727 4.59818 3.70105L3.5824 4.71684C3.35404 4.94519 3.35404 5.32316 3.5824 5.55151C3.69264 5.66175 3.84225 5.72475 3.99974 5.72475Z" fill="white" />
                                    <path d="M7.36253 5.72475C7.51214 5.72475 7.66175 5.66963 7.77987 5.55151L8.79565 4.53573C9.02401 4.30737 9.02401 3.92941 8.79565 3.70105C8.5673 3.4727 8.18933 3.4727 7.96098 3.70105L6.94519 4.71684C6.71684 4.94519 6.71684 5.32316 6.94519 5.55151C7.05543 5.66175 7.21292 5.72475 7.36253 5.72475Z" fill="white" />
                                    <path d="M10.7248 5.72475C10.8744 5.72475 11.0241 5.66963 11.1422 5.55151L12.158 4.53573C12.3863 4.30737 12.3863 3.92941 12.158 3.70105C11.9296 3.4727 11.5516 3.4727 11.3233 3.70105L10.3075 4.71684C10.0791 4.94519 10.0791 5.32316 10.3075 5.55151C10.4256 5.66175 10.5752 5.72475 10.7248 5.72475Z" fill="white" />
                                    <path d="M14.095 5.72475C14.2446 5.72475 14.3942 5.66963 14.5123 5.55151L15.5281 4.53573C15.7564 4.30737 15.7564 3.92941 15.5281 3.70105C15.2997 3.4727 14.9218 3.4727 14.6934 3.70105L13.6776 4.71684C13.4493 4.94519 13.4493 5.32316 13.6776 5.55151C13.7879 5.66175 13.9375 5.72475 14.095 5.72475Z" fill="white" />
                                    <path d="M17.4577 5.72475C17.6074 5.72475 17.757 5.66963 17.8751 5.55151L18.8909 4.53573C19.1192 4.30737 19.1192 3.92941 18.8909 3.70105C18.6625 3.4727 18.2845 3.4727 18.0562 3.70105L17.0404 4.71684C16.8121 4.94519 16.8121 5.32316 17.0404 5.55151C17.1506 5.66175 17.3081 5.72475 17.4577 5.72475Z" fill="white" />
                                    <path d="M20.82 5.72475C20.9697 5.72475 21.1193 5.66963 21.2374 5.55151L22.2532 4.53573C22.4815 4.30737 22.4815 3.92941 22.2532 3.70105C22.0248 3.4727 21.6469 3.4727 21.4185 3.70105L20.4027 4.71684C20.1744 4.94519 20.1744 5.32316 20.4027 5.55151C20.5208 5.66175 20.6704 5.72475 20.82 5.72475Z" fill="white" />
                                    <path d="M5.43286 7.52796C5.2045 7.2996 4.82654 7.2996 4.59818 7.52796L3.5824 8.55161C3.35404 8.77997 3.35404 9.15794 3.5824 9.38629C3.70051 9.50441 3.85012 9.55953 3.99974 9.55953C4.14935 9.55953 4.29896 9.50441 4.41707 9.38629L5.43286 8.37051C5.66121 8.13428 5.66121 7.76418 5.43286 7.52796Z" fill="white" />
                                    <path d="M7.36253 9.55946C7.51214 9.55946 7.66175 9.50434 7.77987 9.38623L8.79565 8.37044C9.02401 8.14209 9.02401 7.76412 8.79565 7.53577C8.5673 7.30741 8.18933 7.30741 7.96098 7.53577L6.94519 8.55155C6.71684 8.77991 6.71684 9.15787 6.94519 9.38623C7.05543 9.49647 7.21292 9.55946 7.36253 9.55946Z" fill="white" />
                                    <path d="M10.7248 9.55946C10.8744 9.55946 11.0241 9.50434 11.1422 9.38623L12.158 8.37044C12.3863 8.14209 12.3863 7.76412 12.158 7.53577C11.9296 7.30741 11.5516 7.30741 11.3233 7.53577L10.3075 8.55155C10.0791 8.77991 10.0791 9.15787 10.3075 9.38623C10.4256 9.49647 10.5752 9.55946 10.7248 9.55946Z" fill="white" />
                                    <path d="M14.095 9.55946C14.2446 9.55946 14.3942 9.50434 14.5123 9.38623L15.5281 8.37044C15.7564 8.14209 15.7564 7.76412 15.5281 7.53577C15.2997 7.30741 14.9218 7.30741 14.6934 7.53577L13.6776 8.55155C13.4493 8.77991 13.4493 9.15787 13.6776 9.38623C13.7879 9.49647 13.9375 9.55946 14.095 9.55946Z" fill="white" />
                                    <path d="M17.4577 9.55946C17.6074 9.55946 17.757 9.50434 17.8751 9.38623L18.8909 8.37044C19.1192 8.14209 19.1192 7.76412 18.8909 7.53577C18.6625 7.30741 18.2845 7.30741 18.0562 7.53577L17.0404 8.55155C16.8121 8.77991 16.8121 9.15787 17.0404 9.38623C17.1506 9.49647 17.3081 9.55946 17.4577 9.55946Z" fill="white" />
                                    <path d="M20.82 9.55946C20.9697 9.55946 21.1193 9.50434 21.2374 9.38623L22.2532 8.37044C22.4815 8.14209 22.4815 7.76412 22.2532 7.53577C22.0248 7.30741 21.6469 7.30741 21.4185 7.53577L20.4027 8.55155C20.1744 8.77991 20.1744 9.15787 20.4027 9.38623C20.5208 9.49647 20.6704 9.55946 20.82 9.55946Z" fill="white" />
                                    <path d="M30.4897 25.379C32.474 25.379 34.0882 23.7648 34.0882 21.7804C34.0882 19.7961 32.474 18.1819 30.4897 18.1819C28.5053 18.1819 26.8911 19.7961 26.8911 21.7804C26.8911 23.7648 28.5053 25.379 30.4897 25.379ZM30.4897 19.363C31.8204 19.363 32.9071 20.4497 32.9071 21.7804C32.9071 23.1112 31.8204 24.1979 30.4897 24.1979C29.1589 24.1979 28.0723 23.1112 28.0723 21.7804C28.0723 20.4497 29.1589 19.363 30.4897 19.363Z" fill="white" />
                                    <path d="M46.4899 28.7333C46.4741 28.7176 46.4663 28.7018 46.4505 28.694C44.3244 26.1978 41.3165 24.6781 38.0722 24.4103V16.851C38.0722 15.7801 37.1982 14.9061 36.1194 14.9061H34.1194V13.0871H36.1194C37.1982 13.0871 38.0722 12.213 38.0722 11.1343V1.95283C38.0722 0.874048 37.1982 0 36.1194 0H1.95283C0.874048 0 0 0.874048 0 1.95283V11.1264C0 12.2052 0.874048 13.0792 1.95283 13.0792H3.9529V14.8982H1.95283C0.874048 14.8982 0 15.7722 0 16.8431V26.0246C0 27.1033 0.874048 27.9774 1.95283 27.9774H3.9529V29.8042H1.95283C0.874048 29.8042 0 30.6783 0 31.7571V40.9306C0 42.0094 0.874048 42.8913 1.95283 42.8913H26.4262C27.686 45.0489 29.5838 46.8206 31.9382 47.8994C32.3791 48.1041 32.8516 48.2931 33.3319 48.4427C34.5367 48.8207 35.7887 49.0175 37.0643 49.0175C38.4502 49.0175 39.8046 48.7892 41.096 48.3403H41.1039C41.7417 48.1199 42.3795 47.8364 42.9937 47.5057C43.0094 47.4978 43.0331 47.482 43.0488 47.4742C46.9545 45.293 49.3876 41.1747 49.3876 36.7021C49.3876 34.3556 48.7262 32.072 47.4742 30.1035C47.1907 29.6231 46.8521 29.1664 46.4899 28.7333ZM42.2299 46.5529C41.9149 46.7182 41.5921 46.8678 41.2613 46.9938L36.0722 32.4894H38.3951L41.4188 42.4582C41.4976 42.7102 41.7259 42.8756 41.9858 42.8756H41.9937C42.2535 42.8756 42.4819 42.7023 42.5527 42.4504L44.663 35.0958C44.7103 34.9225 44.6788 34.7335 44.5764 34.5839C44.104 33.9304 42.9543 31.9697 43.3165 30.7806C43.4976 30.1901 43.8677 29.7491 44.3717 29.5444C44.789 29.3712 45.2536 29.3948 45.6709 29.5838C45.9465 29.9145 46.1985 30.2609 46.4269 30.6153C46.7812 32.3161 45.8048 35.1588 45.7891 35.206L42.2299 46.5529ZM33.1429 47.0962C32.9855 47.0332 32.8201 46.9781 32.6626 46.9072L27.812 31.6311H29.883L34.0879 44.1748L33.1429 47.0962ZM34.6863 42.2378L31.135 31.6311H31.4263C31.7492 31.6311 32.0169 31.3633 32.0169 31.0405C32.0169 30.7177 31.7492 30.4499 31.4263 30.4499H30.3161H27.8278C29.8909 27.3947 33.3398 25.5364 37.0643 25.5364C39.7967 25.5364 42.3952 26.5443 44.4111 28.3239C44.2457 28.3554 44.0803 28.4026 43.915 28.4656C43.0803 28.8042 42.4661 29.5129 42.1826 30.4499C41.6629 32.1429 42.9543 34.3005 43.4504 35.0485L41.97 40.2062L39.6314 32.4894H39.907C40.2298 32.4894 40.4975 32.2216 40.4975 31.8988C40.4975 31.576 40.2298 31.3082 39.907 31.3082H34.2532C33.9304 31.3082 33.6626 31.576 33.6626 31.8988C33.6626 32.2216 33.9304 32.4894 34.2532 32.4894H34.828L36.3635 36.7809L34.6863 42.2378ZM1.18115 11.1264V1.95283C1.18115 1.52761 1.52761 1.18115 1.95283 1.18115H36.1273C36.5525 1.18115 36.899 1.52761 36.899 1.95283V11.1264C36.899 11.5516 36.5525 11.8981 36.1273 11.8981H1.95283C1.52761 11.8981 1.18115 11.5516 1.18115 11.1264ZM5.12617 13.0792H32.9382V14.8982H5.12617V13.0792ZM1.18115 26.0324V16.851C1.18115 16.4258 1.52761 16.0872 1.95283 16.0872H4.52772H4.5356H4.54347H33.5209H33.5288H33.5367H36.1194C36.5446 16.0872 36.8911 16.4337 36.8911 16.851V24.3631C34.2532 24.4025 31.7571 25.2765 29.7097 26.8041H1.95283C1.52761 26.7963 1.18115 26.4498 1.18115 26.0324ZM5.12617 27.9774H28.3317C27.7805 28.5286 27.2766 29.1428 26.8277 29.8042H5.12617V27.9774ZM1.95283 41.7023C1.52761 41.7023 1.18115 41.3558 1.18115 40.9227V31.7571C1.18115 31.3319 1.52761 30.9854 1.95283 30.9854H26.1348C25.2214 32.7335 24.7411 34.6942 24.7411 36.6785C24.7411 38.4423 25.1269 40.1432 25.8198 41.7023H1.95283ZM25.9143 36.6785C25.9143 35.1824 26.2293 33.7099 26.8041 32.3476L31.1822 46.1434C27.9459 44.1276 25.9143 40.5527 25.9143 36.6785ZM34.2611 47.4663L35.269 44.3559V44.3481L37.0092 38.655L40.1353 47.3876C38.2376 47.9309 36.1824 47.9545 34.2611 47.4663ZM43.7732 45.5765L46.9072 35.584C46.9387 35.5052 47.3482 34.3005 47.5608 32.9146C47.9939 34.1115 48.2144 35.3792 48.2144 36.6785C48.2144 40.2062 46.545 43.4898 43.7732 45.5765Z" fill="white" />
                                    <path d="M49.9463 27.8669C48.2849 24.1817 45.1351 22.5124 42.7965 21.7643C42.4815 21.6619 42.1508 21.8352 42.0563 22.1501C41.9539 22.4572 42.1272 22.7958 42.4421 22.8903C44.5603 23.5675 47.3951 25.0636 48.8754 28.3551C48.9778 28.5756 49.1904 28.7016 49.4109 28.7016C49.4896 28.7016 49.5762 28.6858 49.655 28.6464C49.9542 28.5126 50.0802 28.1661 49.9463 27.8669Z" fill="white" />
                                    <path d="M40.0173 22.3706C40.033 22.3706 40.2771 22.3942 40.6866 22.4572C40.7181 22.4651 40.7496 22.4651 40.7889 22.4651C41.0724 22.4651 41.3244 22.2603 41.3716 21.969C41.4268 21.6461 41.2063 21.339 40.8834 21.2918C40.3873 21.2052 40.096 21.1894 40.096 21.1894C39.7732 21.1579 39.4897 21.4099 39.4661 21.7406C39.4503 22.0635 39.6944 22.347 40.0173 22.3706Z" fill="white" />
                                </svg>
                            </div>
                            <h4 class="tab__title">WordPress Hosting</h4>
                        </div>

                        <div class="single__tab tab__btn" data-tab="cloud">
                            <div class="tab__icon">
                                <svg width="45" height="45" viewBox="0 0 55 43" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M54.8776 24.2225C54.6839 22.3477 53.922 20.5768 52.6941 19.147C51.4661 17.7171 49.8307 16.6965 48.0067 16.2218C48.421 14.0278 48.0076 11.758 46.8465 9.8509C45.6853 7.94377 43.8587 6.53452 41.7193 5.89531C39.6394 5.27913 37.4077 5.42797 35.428 6.31488C34.6962 5.25587 33.8279 4.29803 32.8456 3.46615C26.6705 -1.76013 17.3948 -0.988247 12.1684 5.18693C10.9146 6.66812 9.96731 8.38344 9.3814 10.2335C8.79549 12.0835 8.58263 14.0314 8.75517 15.9643C6.37783 16.1302 4.24831 17.0427 2.68202 18.584C0.95233 20.2854 0 22.6258 0 25.1748C0.00393187 27.2986 0.734929 29.3571 2.07137 31.0077C3.24352 32.4484 4.97482 34.128 7.98307 34.3293C8.02212 34.332 8.03521 34.3328 10.5289 34.3337C10.7085 34.3358 10.8841 34.281 11.0305 34.1771C11.177 34.0733 11.2868 33.9257 11.3443 33.7557C11.3885 33.6259 11.4012 33.4875 11.3813 33.3519C11.3614 33.2163 11.3095 33.0874 11.2299 32.9758C11.1502 32.8643 11.0452 32.7733 10.9234 32.7104C10.8016 32.6475 10.6666 32.6146 10.5295 32.6143C9.62425 32.6143 8.26661 32.6133 8.07544 32.6123C5.75603 32.4491 4.41342 31.1618 3.40627 29.9238C2.31827 28.5799 1.72313 26.904 1.71982 25.1748C1.71982 23.091 2.48977 21.186 3.88785 19.8108C5.35759 18.3652 7.36953 17.6198 9.70975 17.6593L9.81403 17.661C9.92657 17.6628 10.0381 17.6399 10.1409 17.5941C10.2437 17.5482 10.3352 17.4804 10.4091 17.3955C10.4829 17.3106 10.5373 17.2105 10.5685 17.1024C10.5996 16.9942 10.6067 16.8806 10.5893 16.7694L10.5731 16.6663C10.1087 13.7098 10.6829 10.6837 12.1979 8.10275C13.713 5.52181 16.0753 3.54543 18.8832 2.50981C21.6911 1.47419 24.771 1.44328 27.5991 2.42235C30.4271 3.40142 32.8287 5.32998 34.3952 7.88L34.4395 7.95209C34.5442 8.12209 34.7106 8.24497 34.9039 8.29497C35.0971 8.34497 35.3022 8.31821 35.4762 8.22029L35.5499 8.17877C36.4058 7.69908 37.3492 7.39577 38.3242 7.28676C39.2993 7.17775 40.2864 7.26526 41.2271 7.5441C42.1495 7.8169 43.0085 8.27029 43.7542 8.87794C44.4999 9.48558 45.1174 10.2354 45.5709 11.0837C46.4895 12.8202 46.6833 14.8498 46.1099 16.7288L46.1085 16.7335C46.077 16.8392 46.0684 16.9504 46.0835 17.0596C46.0985 17.1688 46.1367 17.2736 46.1956 17.3668C46.2545 17.46 46.3327 17.5395 46.4249 17.6C46.517 17.6605 46.6211 17.7006 46.73 17.7175C48.0471 17.9128 49.2912 18.4453 50.3417 19.2632C51.125 19.8814 51.7777 20.6492 52.2617 21.5218C52.7457 22.3945 53.0514 23.3546 53.1611 24.3464C53.2709 25.3382 53.1824 26.342 52.9008 27.2993C52.6192 28.2566 52.1502 29.1485 51.521 29.9229C50.2415 31.4956 48.9607 32.5549 46.8708 32.612C46.7269 32.612 44.8293 32.6139 44.0951 32.6143C43.958 32.6146 43.823 32.6476 43.7012 32.7105C43.5793 32.7734 43.4743 32.8645 43.3947 32.9761C43.3151 33.0877 43.2632 33.2167 43.2434 33.3524C43.2235 33.488 43.2363 33.6265 43.2806 33.7562C43.3381 33.9263 43.448 34.0738 43.5944 34.1776C43.7409 34.2815 43.9165 34.3363 44.096 34.3342C46.8745 34.3323 46.8918 34.3319 46.9067 34.3315C49.8279 34.2548 51.5526 32.6085 52.8547 31.0079C53.6238 30.0668 54.1987 28.9826 54.5459 27.8178C54.8931 26.6531 55.0059 25.4311 54.8776 24.2225Z" fill="#2D3C58" />
                                    <path d="M40.5196 15.1958H14.4085C14.2291 15.1958 14.0515 15.2311 13.8857 15.2998C13.72 15.3684 13.5694 15.469 13.4426 15.5959C13.3157 15.7227 13.2151 15.8733 13.1465 16.0391C13.0778 16.2048 13.0425 16.3824 13.0425 16.5618V22.0966C13.0425 22.276 13.0778 22.4536 13.1465 22.6194C13.2151 22.7851 13.3157 22.9357 13.4426 23.0625C13.5694 23.1894 13.72 23.29 13.8857 23.3587C14.0515 23.4273 14.2291 23.4626 14.4085 23.4626H40.5197C40.6991 23.4626 40.8767 23.4273 41.0425 23.3587C41.2082 23.29 41.3588 23.1894 41.4856 23.0625C41.6125 22.9357 41.7131 22.7851 41.7817 22.6194C41.8504 22.4536 41.8857 22.276 41.8857 22.0966V16.5619C41.8857 16.1996 41.7418 15.8521 41.4856 15.5959C41.2294 15.3397 40.8819 15.1958 40.5196 15.1958ZM40.1656 21.7428H14.7625V16.9152H40.1666L40.1656 21.7428Z" fill="#2D3C58" />
                                    <path d="M17.4703 20.1891H28.2133C28.4352 20.192 28.6499 20.1108 28.8145 19.9619C28.9791 19.8131 29.0814 19.6075 29.1008 19.3865C29.1086 19.2689 29.0922 19.1511 29.0526 19.0402C29.0131 18.9293 28.9511 18.8277 28.8706 18.7417C28.7902 18.6557 28.6929 18.5872 28.5849 18.5403C28.4768 18.4934 28.3603 18.4693 28.2425 18.4693H17.4998C17.2779 18.4665 17.0631 18.5476 16.8985 18.6965C16.7339 18.8453 16.6317 19.0509 16.6123 19.272C16.6044 19.3895 16.6208 19.5073 16.6604 19.6182C16.7 19.7291 16.7619 19.8307 16.8423 19.9167C16.9228 20.0027 17.02 20.0712 17.128 20.1181C17.236 20.1649 17.3525 20.1891 17.4703 20.1891Z" fill="#2D3C58" />
                                    <path d="M32.4433 20.1891H32.907C33.1289 20.192 33.3437 20.1108 33.5083 19.9619C33.6729 19.8131 33.7752 19.6075 33.7946 19.3865C33.8024 19.2689 33.786 19.1511 33.7464 19.0402C33.7068 18.9293 33.6449 18.8277 33.5644 18.7417C33.484 18.6557 33.3867 18.5872 33.2786 18.5403C33.1706 18.4934 33.0541 18.4693 32.9363 18.4693H32.4724C32.2505 18.4665 32.0358 18.5476 31.8712 18.6965C31.7066 18.8453 31.6043 19.0509 31.5849 19.272C31.5771 19.3895 31.5935 19.5074 31.6331 19.6183C31.6727 19.7292 31.7346 19.8308 31.8151 19.9168C31.8956 20.0028 31.9929 20.0713 32.1009 20.1182C32.209 20.165 32.3255 20.1892 32.4433 20.1891Z" fill="#2D3C58" />
                                    <path d="M35.6643 20.1891H36.1283C36.3502 20.1919 36.565 20.1108 36.7295 19.9619C36.8941 19.8131 36.9964 19.6075 37.0158 19.3865C37.0236 19.2689 37.0072 19.1511 36.9676 19.0402C36.9281 18.9292 36.8661 18.8276 36.7857 18.7416C36.7052 18.6557 36.6079 18.5871 36.4999 18.5403C36.3918 18.4934 36.2753 18.4693 36.1575 18.4693H35.6936C35.4717 18.4665 35.257 18.5476 35.0924 18.6965C34.9278 18.8453 34.8255 19.0509 34.8061 19.272C34.7983 19.3895 34.8147 19.5073 34.8542 19.6183C34.8938 19.7292 34.9558 19.8308 35.0363 19.9168C35.1167 20.0027 35.214 20.0713 35.322 20.1181C35.4301 20.165 35.5466 20.1892 35.6643 20.1891Z" fill="#2D3C58" />
                                    <path d="M40.5196 24.9644H14.4085C14.2291 24.9644 14.0515 24.9997 13.8857 25.0683C13.72 25.137 13.5694 25.2376 13.4426 25.3644C13.3157 25.4913 13.2151 25.6419 13.1465 25.8076C13.0778 25.9733 13.0425 26.151 13.0425 26.3304V31.8652C13.0425 32.0446 13.0778 32.2222 13.1465 32.3879C13.2151 32.5537 13.3157 32.7042 13.4426 32.8311C13.5694 32.9579 13.72 33.0586 13.8857 33.1272C14.0515 33.1959 14.2291 33.2312 14.4085 33.2312H40.5197C40.6991 33.2312 40.8767 33.1959 41.0425 33.1272C41.2082 33.0586 41.3588 32.9579 41.4856 32.8311C41.6125 32.7042 41.7131 32.5537 41.7817 32.3879C41.8504 32.2222 41.8857 32.0446 41.8857 31.8652V26.3304C41.8857 25.9681 41.7418 25.6206 41.4856 25.3644C41.2294 25.1083 40.8819 24.9644 40.5196 24.9644ZM40.1656 31.5114H14.7625V26.6837H40.1666L40.1656 31.5114Z" fill="#2D3C58" />
                                    <path d="M17.4703 29.9577H28.2133C28.4352 29.9605 28.6499 29.8794 28.8145 29.7305C28.9791 29.5816 29.0814 29.3761 29.1008 29.155C29.1086 29.0375 29.0922 28.9197 29.0526 28.8087C29.013 28.6978 28.9511 28.5963 28.8706 28.5103C28.7901 28.4243 28.6929 28.3557 28.5848 28.3089C28.4768 28.262 28.3603 28.2379 28.2425 28.2379H17.4998C17.2779 28.235 17.0631 28.3162 16.8985 28.4651C16.7339 28.614 16.6316 28.8196 16.6122 29.0406C16.6044 29.1581 16.6208 29.276 16.6604 29.3868C16.7 29.4977 16.7619 29.5993 16.8424 29.6853C16.9228 29.7712 17.02 29.8398 17.128 29.8866C17.2361 29.9335 17.3525 29.9577 17.4703 29.9577Z" fill="#2D3C58" />
                                    <path d="M32.4433 29.9577H32.907C33.1289 29.9605 33.3437 29.8794 33.5083 29.7305C33.6729 29.5816 33.7752 29.3761 33.7946 29.155C33.8024 29.0375 33.786 28.9197 33.7464 28.8087C33.7068 28.6978 33.6448 28.5963 33.5644 28.5103C33.4839 28.4243 33.3867 28.3557 33.2786 28.3089C33.1706 28.262 33.0541 28.2379 32.9363 28.2379H32.4724C32.2505 28.235 32.0357 28.3162 31.8711 28.4651C31.7065 28.614 31.6043 28.8196 31.5849 29.0406C31.5771 29.1581 31.5935 29.276 31.6331 29.3869C31.6727 29.4978 31.7347 29.5994 31.8151 29.6854C31.8956 29.7714 31.9929 29.8399 32.1009 29.8867C32.209 29.9336 32.3255 29.9577 32.4433 29.9577Z" fill="#2D3C58" />
                                    <path d="M35.6643 29.9577H36.1283C36.3502 29.9605 36.565 29.8793 36.7295 29.7305C36.8941 29.5816 36.9963 29.3761 37.0158 29.155C37.0236 29.0375 37.0072 28.9196 36.9676 28.8087C36.928 28.6978 36.8661 28.5962 36.7856 28.5102C36.7051 28.4242 36.6079 28.3557 36.4998 28.3089C36.3918 28.262 36.2753 28.2378 36.1575 28.2379H35.6936C35.4717 28.235 35.2569 28.3162 35.0923 28.4651C34.9277 28.614 34.8255 28.8196 34.8061 29.0406C34.7983 29.1581 34.8147 29.276 34.8543 29.3869C34.8939 29.4978 34.9558 29.5994 35.0363 29.6853C35.1167 29.7713 35.214 29.8399 35.322 29.8867C35.4301 29.9335 35.5466 29.9577 35.6643 29.9577Z" fill="#2D3C58" />
                                    <path d="M40.5197 34.7332H14.4085C14.0463 34.7336 13.6991 34.8776 13.443 35.1337C13.1869 35.3898 13.0429 35.737 13.0425 36.0992V41.634C13.0429 41.9961 13.1869 42.3434 13.443 42.5995C13.6991 42.8555 14.0463 42.9996 14.4085 43H40.5197C40.8819 42.9996 41.2291 42.8555 41.4852 42.5995C41.7413 42.3434 41.8853 41.9961 41.8857 41.634V36.0992C41.8853 35.737 41.7413 35.3898 41.4852 35.1337C41.2291 34.8776 40.8819 34.7336 40.5197 34.7332ZM40.1657 41.2802H14.7625V36.4525H40.1666L40.1657 41.2802Z" fill="#2D3C58" />
                                    <path d="M17.4705 39.7265H28.2428C28.3566 39.7277 28.4694 39.7064 28.5749 39.6638C28.6803 39.6211 28.7763 39.558 28.8571 39.478C28.938 39.398 29.0022 39.3028 29.046 39.1979C29.0898 39.0929 29.1124 38.9803 29.1124 38.8666C29.1124 38.7528 29.0898 38.6402 29.046 38.5352C29.0022 38.4303 28.938 38.3351 28.8571 38.2551C28.7763 38.1751 28.6803 38.112 28.5749 38.0693C28.4694 38.0267 28.3566 38.0054 28.2428 38.0066H17.4705C17.2441 38.0092 17.0278 38.1009 16.8686 38.2619C16.7094 38.4229 16.6201 38.6401 16.6201 38.8666C16.6201 39.093 16.7094 39.3102 16.8686 39.4712C17.0278 39.6322 17.2441 39.7239 17.4705 39.7265Z" fill="#2D3C58" />
                                    <path d="M32.4438 39.7265H32.9373C33.1637 39.7239 33.3799 39.6322 33.5391 39.4712C33.6983 39.3102 33.7876 39.093 33.7876 38.8666C33.7876 38.6401 33.6983 38.4229 33.5391 38.2619C33.3799 38.1009 33.1637 38.0092 32.9373 38.0066H32.4438C32.3301 38.0054 32.2172 38.0267 32.1118 38.0693C32.0063 38.112 31.9104 38.1751 31.8295 38.2551C31.7486 38.3351 31.6844 38.4303 31.6406 38.5352C31.5968 38.6402 31.5742 38.7528 31.5742 38.8666C31.5742 38.9803 31.5968 39.0929 31.6406 39.1979C31.6844 39.3028 31.7486 39.398 31.8295 39.478C31.9104 39.558 32.0063 39.6211 32.1118 39.6638C32.2172 39.7064 32.3301 39.7277 32.4438 39.7265Z" fill="#2D3C58" />
                                    <path d="M35.6648 39.7265H36.1583C36.272 39.7277 36.3849 39.7064 36.4903 39.6638C36.5958 39.6211 36.6917 39.558 36.7726 39.478C36.8535 39.398 36.9177 39.3028 36.9615 39.1979C37.0053 39.0929 37.0279 38.9803 37.0279 38.8666C37.0279 38.7528 37.0053 38.6402 36.9615 38.5352C36.9177 38.4303 36.8535 38.3351 36.7726 38.2551C36.6917 38.1751 36.5958 38.112 36.4903 38.0693C36.3849 38.0267 36.272 38.0054 36.1583 38.0066H35.6648C35.4384 38.0092 35.2221 38.1009 35.0629 38.2619C34.9037 38.4229 34.8145 38.6401 34.8145 38.8666C34.8145 39.093 34.9037 39.3102 35.0629 39.4712C35.2221 39.6322 35.4384 39.7239 35.6648 39.7265Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h4 class="tab__title">Cloud Hosting</h4>
                        </div>

                        <div class="single__tab tab__btn" data-tab="vps">
                            <div class="tab__icon">
                                <svg width="45" height="45" viewBox="0 0 53 47" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M51.1221 12.2109C52.1571 12.2109 53.0001 11.3679 53.0001 10.3329V1.87796C53.0001 0.842994 52.1571 0 51.1221 0H15.2573C14.2224 0 13.3794 0.842994 13.3794 1.87796V10.3329C13.3794 11.3679 14.2224 12.2109 15.2573 12.2109H16.1755V14.7649H15.2573C14.2224 14.7649 13.3794 15.6079 13.3794 16.6429V22.2851C9.106 22.5021 5.68395 25.9826 5.58379 30.2893C2.27024 31.4078 0 34.5377 0 38.0599C0 42.5837 3.68079 46.2728 8.21293 46.2728C10.0325 46.2728 11.8019 45.6635 13.2375 44.5451C14.6731 45.6635 16.4425 46.2728 18.2621 46.2728C20.2485 46.2728 22.1265 45.5717 23.6122 44.2864C25.0978 45.5717 26.9758 46.2728 28.9623 46.2728C32.1923 46.2728 34.9884 44.3865 36.3238 41.6656H51.1221C52.1571 41.6656 53.0001 40.8226 53.0001 39.7876V31.341C53.0001 30.306 52.1571 29.463 51.1221 29.463H50.204V26.9758H51.1221C52.1571 26.9758 53.0001 26.1328 53.0001 25.0978V16.6429C53.0001 15.6079 52.1571 14.7649 51.1221 14.7649H50.204V12.2109H51.1221ZM14.6314 10.3329V1.87796C14.6314 1.53575 14.9151 1.25197 15.2573 1.25197H51.1221C51.4643 1.25197 51.7481 1.53575 51.7481 1.87796V10.3329C51.7481 10.6751 51.4643 10.9589 51.1221 10.9589H49.578H16.8014H15.2573C14.9068 10.9589 14.6314 10.6751 14.6314 10.3329ZM28.9623 45.0209C27.1093 45.0209 25.3649 44.3031 24.0545 42.9927C23.9293 42.8675 23.7708 42.8091 23.6122 42.8091C23.4536 42.8091 23.295 42.8675 23.1698 42.9927C21.8594 44.3031 20.115 45.0209 18.2621 45.0209C16.5677 45.0209 14.9318 44.3949 13.6548 43.2681C13.4211 43.0594 13.0622 43.0594 12.8285 43.2681C11.5515 44.4032 9.91561 45.0209 8.22127 45.0209C4.3819 45.0209 1.26032 41.8993 1.26032 38.0599C1.26032 34.93 3.37197 32.1756 6.3934 31.3493C6.67718 31.2742 6.8608 31.0155 6.85245 30.7234L6.83576 30.473C6.83576 26.6336 9.95734 23.512 13.7967 23.512C15.9334 23.512 17.9282 24.4802 19.2637 26.1745C19.4723 26.4416 19.8646 26.4917 20.14 26.283C21.2501 25.4234 22.5689 24.9643 23.9627 24.9643C27.2178 24.9643 29.9471 27.51 30.1725 30.7567C30.1892 31.0238 30.3812 31.2575 30.6482 31.316C33.7531 32.0922 35.9232 34.8632 35.9232 38.0599C35.9149 41.8993 32.7933 45.0209 28.9623 45.0209ZM51.7481 31.341V39.7876C51.7481 40.1298 51.4643 40.4136 51.1221 40.4136H36.8246C37.05 39.6708 37.1752 38.8779 37.1752 38.0599C37.1752 34.8883 35.3723 32.0755 32.6264 30.715H49.5864H51.1305C51.4643 30.715 51.7481 30.9988 51.7481 31.341ZM48.9521 29.463H31.2325C31.0155 28.5616 30.6315 27.7186 30.1224 26.9758H48.9521V29.463ZM51.7481 16.6429V25.0978C51.7481 25.44 51.4643 25.7238 51.1221 25.7238H49.8451C49.7617 25.6821 49.6699 25.6571 49.578 25.6571H28.9706C27.6352 24.4468 25.8741 23.7123 23.9544 23.7123C22.477 23.7123 21.0665 24.138 19.8479 24.9476C18.4791 23.4452 16.6345 22.5188 14.623 22.3101V16.6429C14.623 16.3007 14.9068 16.0169 15.249 16.0169H16.7931H49.5697H51.1138C51.4643 16.0169 51.7481 16.3007 51.7481 16.6429ZM48.9521 14.7649H17.4274V12.2109H48.9521V14.7649Z" fill="#2D3C58" />
                                    <path d="M17.294 5.43372C17.6362 5.43372 17.9199 5.14994 17.9199 4.80773V3.53907C17.9199 3.19687 17.6362 2.91309 17.294 2.91309C16.9517 2.91309 16.668 3.19687 16.668 3.53907V4.80773C16.668 5.15829 16.9517 5.43372 17.294 5.43372Z" fill="#2D3C58" />
                                    <path d="M20.165 5.43372C20.5073 5.43372 20.791 5.14994 20.791 4.80773V3.53907C20.791 3.19687 20.5073 2.91309 20.165 2.91309C19.8228 2.91309 19.5391 3.19687 19.5391 3.53907V4.80773C19.5391 5.15829 19.8228 5.43372 20.165 5.43372Z" fill="#2D3C58" />
                                    <path d="M23.0366 5.43372C23.3788 5.43372 23.6626 5.14994 23.6626 4.80773V3.53907C23.6626 3.19687 23.3788 2.91309 23.0366 2.91309C22.6944 2.91309 22.4106 3.19687 22.4106 3.53907V4.80773C22.4106 5.15829 22.6944 5.43372 23.0366 5.43372Z" fill="#2D3C58" />
                                    <path d="M25.9077 5.43372C26.2499 5.43372 26.5337 5.14994 26.5337 4.80773V3.53907C26.5337 3.19687 26.2499 2.91309 25.9077 2.91309C25.5655 2.91309 25.2817 3.19687 25.2817 3.53907V4.80773C25.2817 5.15829 25.5655 5.43372 25.9077 5.43372Z" fill="#2D3C58" />
                                    <path d="M17.294 9.29798C17.6362 9.29798 17.9199 9.0142 17.9199 8.67199V7.40333C17.9199 7.06112 17.6362 6.77734 17.294 6.77734C16.9517 6.77734 16.668 7.06112 16.668 7.40333V8.67199C16.668 9.0142 16.9517 9.29798 17.294 9.29798Z" fill="#2D3C58" />
                                    <path d="M20.165 9.29798C20.5073 9.29798 20.791 9.0142 20.791 8.67199V7.40333C20.791 7.06112 20.5073 6.77734 20.165 6.77734C19.8228 6.77734 19.5391 7.06112 19.5391 7.40333V8.67199C19.5391 9.0142 19.8228 9.29798 20.165 9.29798Z" fill="#2D3C58" />
                                    <path d="M23.0366 9.29798C23.3788 9.29798 23.6626 9.0142 23.6626 8.67199V7.40333C23.6626 7.06112 23.3788 6.77734 23.0366 6.77734C22.6944 6.77734 22.4106 7.06112 22.4106 7.40333V8.67199C22.4106 9.0142 22.6944 9.29798 23.0366 9.29798Z" fill="#2D3C58" />
                                    <path d="M25.9077 9.29798C26.2499 9.29798 26.5337 9.0142 26.5337 8.67199V7.40333C26.5337 7.06112 26.2499 6.77734 25.9077 6.77734C25.5655 6.77734 25.2817 7.06112 25.2817 7.40333V8.67199C25.2817 9.0142 25.5655 9.29798 25.9077 9.29798Z" fill="#2D3C58" />
                                    <path d="M47.2993 8.64692C48.6264 8.64692 49.7031 7.57023 49.7031 6.24314C49.7031 4.91605 48.6264 3.83936 47.2993 3.83936C45.9722 3.83936 44.8955 4.91605 44.8955 6.24314C44.8955 7.56188 45.9805 8.64692 47.2993 8.64692ZM47.2993 5.09133C47.9336 5.09133 48.4511 5.60881 48.4511 6.24314C48.4511 6.87747 47.9336 7.39495 47.2993 7.39495C46.665 7.39495 46.1475 6.87747 46.1475 6.24314C46.1475 5.60881 46.665 5.09133 47.2993 5.09133Z" fill="#2D3C58" />
                                    <path d="M40.5556 8.64692C41.8827 8.64692 42.9594 7.57023 42.9594 6.24314C42.9594 4.91605 41.8827 3.83936 40.5556 3.83936C39.2286 3.83936 38.1519 4.91605 38.1519 6.24314C38.1519 7.56188 39.2369 8.64692 40.5556 8.64692ZM40.5556 5.09133C41.19 5.09133 41.7075 5.60881 41.7075 6.24314C41.7075 6.87747 41.19 7.39495 40.5556 7.39495C39.9213 7.39495 39.4038 6.87747 39.4038 6.24314C39.4038 5.60881 39.9213 5.09133 40.5556 5.09133Z" fill="#2D3C58" />
                                    <path d="M29.6719 6.73561H35.4894C35.8316 6.73561 36.1154 6.45183 36.1154 6.10963C36.1154 5.76742 35.8316 5.48364 35.4894 5.48364H29.6719C29.3297 5.48364 29.0459 5.76742 29.0459 6.10963C29.0459 6.45183 29.3297 6.73561 29.6719 6.73561Z" fill="#2D3C58" />
                                    <path d="M17.294 17.678C16.9517 17.678 16.668 17.9618 16.668 18.304V19.5726C16.668 19.9148 16.9517 20.1986 17.294 20.1986C17.6362 20.1986 17.9199 19.9148 17.9199 19.5726V18.304C17.9199 17.9618 17.6445 17.678 17.294 17.678Z" fill="#2D3C58" />
                                    <path d="M20.165 17.678C19.8228 17.678 19.5391 17.9618 19.5391 18.304V19.5726C19.5391 19.9148 19.8228 20.1986 20.165 20.1986C20.5073 20.1986 20.791 19.9148 20.791 19.5726V18.304C20.791 17.9618 20.5156 17.678 20.165 17.678Z" fill="#2D3C58" />
                                    <path d="M23.0366 17.678C22.6944 17.678 22.4106 17.9618 22.4106 18.304V19.5726C22.4106 19.9148 22.6944 20.1986 23.0366 20.1986C23.3788 20.1986 23.6626 19.9148 23.6626 19.5726V18.304C23.6626 17.9618 23.3872 17.678 23.0366 17.678Z" fill="#2D3C58" />
                                    <path d="M25.9077 17.678C25.5655 17.678 25.2817 17.9618 25.2817 18.304V19.5726C25.2817 19.9148 25.5655 20.1986 25.9077 20.1986C26.2499 20.1986 26.5337 19.9148 26.5337 19.5726V18.304C26.5337 17.9618 26.2583 17.678 25.9077 17.678Z" fill="#2D3C58" />
                                    <path d="M47.2993 18.6042C45.9722 18.6042 44.8955 19.6809 44.8955 21.008C44.8955 22.3351 45.9722 23.4118 47.2993 23.4118C48.6264 23.4118 49.7031 22.3351 49.7031 21.008C49.7031 19.6809 48.6264 18.6042 47.2993 18.6042ZM47.2993 22.1515C46.665 22.1515 46.1475 21.634 46.1475 20.9997C46.1475 20.3654 46.665 19.8479 47.2993 19.8479C47.9336 19.8479 48.4511 20.3654 48.4511 20.9997C48.4511 21.634 47.9336 22.1515 47.2993 22.1515Z" fill="#2D3C58" />
                                    <path d="M40.5556 18.6042C39.2286 18.6042 38.1519 19.6809 38.1519 21.008C38.1519 22.3351 39.2286 23.4118 40.5556 23.4118C41.8827 23.4118 42.9594 22.3351 42.9594 21.008C42.9594 19.6809 41.8827 18.6042 40.5556 18.6042ZM40.5556 22.1515C39.9213 22.1515 39.4038 21.634 39.4038 20.9997C39.4038 20.3654 39.9213 19.8479 40.5556 19.8479C41.19 19.8479 41.7075 20.3654 41.7075 20.9997C41.7075 21.634 41.19 22.1515 40.5556 22.1515Z" fill="#2D3C58" />
                                    <path d="M35.4977 20.2402H29.6719C29.3297 20.2402 29.0459 20.524 29.0459 20.8662C29.0459 21.2084 29.3297 21.4922 29.6719 21.4922H35.4894C35.8316 21.4922 36.1154 21.2084 36.1154 20.8662C36.1154 20.524 35.8399 20.2402 35.4977 20.2402Z" fill="#2D3C58" />
                                    <path d="M47.2993 33.2942C45.9722 33.2942 44.8955 34.3709 44.8955 35.698C44.8955 37.0251 45.9722 38.1018 47.2993 38.1018C48.6264 38.1018 49.7031 37.0251 49.7031 35.698C49.7031 34.3709 48.6264 33.2942 47.2993 33.2942ZM47.2993 36.8498C46.665 36.8498 46.1475 36.3323 46.1475 35.698C46.1475 35.0636 46.665 34.5462 47.2993 34.5462C47.9336 34.5462 48.4511 35.0636 48.4511 35.698C48.4511 36.3323 47.9336 36.8498 47.2993 36.8498Z" fill="#2D3C58" />
                                    <path d="M40.5556 33.2942C39.2286 33.2942 38.1519 34.3709 38.1519 35.698C38.1519 37.0251 39.2286 38.1018 40.5556 38.1018C41.8827 38.1018 42.9594 37.0251 42.9594 35.698C42.9594 34.3709 41.8827 33.2942 40.5556 33.2942ZM40.5556 36.8498C39.9213 36.8498 39.4038 36.3323 39.4038 35.698C39.4038 35.0636 39.9213 34.5462 40.5556 34.5462C41.19 34.5462 41.7075 35.0636 41.7075 35.698C41.7075 36.3323 41.19 36.8498 40.5556 36.8498Z" fill="#2D3C58" />
                                    <path d="M26.0577 35.8816C25.4067 35.8816 24.8725 35.3475 24.8725 34.6964C24.8725 34.0454 25.4067 33.5112 26.0577 33.5112C26.6086 33.5112 27.0927 33.9035 27.2179 34.4377C27.293 34.7799 27.6352 34.9886 27.9691 34.9135C28.3029 34.8383 28.5199 34.5045 28.4448 34.1623C28.1944 33.0438 27.2179 32.2593 26.0661 32.2593C24.7223 32.2593 23.6289 33.3527 23.6289 34.6964C23.6289 36.0402 24.7223 37.1336 26.0661 37.1336C26.7171 37.1336 27.2513 37.6678 27.2513 38.3188C27.2513 38.9698 26.7171 39.504 26.0661 39.504C25.4818 39.504 24.981 39.07 24.8976 38.5024C24.8475 38.1602 24.522 37.9265 24.1881 37.9766C23.8459 38.0267 23.6122 38.3522 23.6623 38.6861C23.8459 39.8629 24.8809 40.756 26.0744 40.756C27.4182 40.756 28.5116 39.6626 28.5116 38.3188C28.5032 36.975 27.4099 35.8816 26.0577 35.8816Z" fill="#2D3C58" />
                                    <path d="M14.9986 32.4847C14.6731 32.3595 14.3142 32.5181 14.189 32.8436L12.0356 38.4023L9.88218 32.8436C9.75698 32.5181 9.39808 32.3595 9.07257 32.4847C8.74706 32.6099 8.58848 32.9688 8.71367 33.2943L11.4513 40.3554C11.5431 40.5974 11.7768 40.756 12.0356 40.756C12.2943 40.756 12.528 40.5974 12.6198 40.3554L15.3575 33.2943C15.4827 32.9771 15.3241 32.6099 14.9986 32.4847Z" fill="#2D3C58" />
                                    <path d="M19.8647 32.2593H17.7363C17.3941 32.2593 17.1104 32.5431 17.1104 32.8853V33.0772V36.2239V40.1383C17.1104 40.4805 17.3941 40.7643 17.7363 40.7643C18.0785 40.7643 18.3623 40.4805 18.3623 40.1383V36.8498H19.8647C21.1333 36.8498 22.16 35.8232 22.16 34.5546C22.16 33.2859 21.1333 32.2593 19.8647 32.2593ZM19.8647 35.5895H18.3623V33.5029H19.8647C20.4406 33.5029 20.908 33.9703 20.908 34.5462C20.908 35.1221 20.4406 35.5895 19.8647 35.5895Z" fill="#2D3C58" />
                                    <path d="M16.7929 25.6068C13.3124 24.4717 11.2759 25.7237 10.1825 26.9673C9.95712 27.2261 9.98216 27.6267 10.2409 27.852C10.3578 27.9605 10.508 28.0106 10.6499 28.0106C10.8252 28.0106 11.0004 27.9355 11.1173 27.7936C12.3442 26.3914 14.122 26.0575 16.4006 26.8004C16.7261 26.9089 17.085 26.7253 17.1852 26.3997C17.302 26.0742 17.1267 25.7153 16.7929 25.6068Z" fill="#2D3C58" />
                                    <path d="M9.25663 30.3646C9.30671 30.3729 9.34844 30.3813 9.39852 30.3813C9.6823 30.3813 9.94104 30.1893 10.0078 29.8972C10.0162 29.8805 10.0662 29.6551 10.1914 29.338C10.3166 29.0208 10.1664 28.6536 9.84088 28.5284C9.52372 28.3948 9.15647 28.5534 9.03128 28.8789C8.86435 29.3046 8.79758 29.5884 8.78923 29.6217C8.71411 29.9556 8.92277 30.2895 9.25663 30.3646Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h4 class="tab__title">vps Hosting</h4>
                        </div>

                        <div class="single__tab tab__btn" data-tab="email">
                            <div class="tab__icon">
                                <svg width="45" height="45" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <g clip-path="url(#clip0_341_3634)">
                                        <path d="M29.3389 7.19751H9.26807C8.87166 7.19751 8.55029 7.51879 8.55029 7.91528C8.55029 8.31178 8.87166 8.63306 9.26807 8.63306H29.339C29.7354 8.63306 30.0568 8.31178 30.0568 7.91528C30.0568 7.51879 29.7354 7.19751 29.3389 7.19751Z" fill="#2D3C58" />
                                        <path d="M29.3389 10.7378H9.26807C8.87166 10.7378 8.55029 11.0591 8.55029 11.4556C8.55029 11.8521 8.87166 12.1733 9.26807 12.1733H29.339C29.7354 12.1733 30.0568 11.8521 30.0568 11.4556C30.0568 11.0591 29.7354 10.7378 29.3389 10.7378Z" fill="#2D3C58" />
                                        <path d="M29.3389 23.4961C29.7353 23.4961 30.0567 23.1748 30.0567 22.7783C30.0567 22.3818 29.7353 22.0605 29.3389 22.0605H9.26807C8.87166 22.0605 8.55029 22.3818 8.55029 22.7783C8.55029 23.1748 8.87166 23.4961 9.26807 23.4961H29.3389Z" fill="#2D3C58" />
                                        <path d="M46.075 16.0017C47.6878 16.0017 49 14.6896 49 13.0767V6.29412C49 4.68123 47.6879 3.36914 46.075 3.36914H7.86345C6.25066 3.36914 4.93847 4.68123 4.93847 6.29412V13.0767C4.93847 14.6896 6.25056 16.0017 7.86345 16.0017H8.5504V18.1838H7.86345C6.25066 18.1838 4.93847 19.4959 4.93847 21.1088V23.021C4.93847 23.4175 5.25984 23.7388 5.65625 23.7388C6.05265 23.7388 6.37402 23.4175 6.37402 23.021V21.1088C6.37402 20.2875 7.04212 19.6193 7.86345 19.6193H46.075C46.8963 19.6193 47.5645 20.2874 47.5645 21.1088V27.8914C47.5645 28.7127 46.8964 29.3808 46.075 29.3808H28.6164V28.3985C28.6164 26.8594 27.3634 25.5918 25.8097 25.5918H2.80669C1.25792 25.5917 0 26.854 0 28.3984V42.8098C0 44.3514 1.25582 45.6165 2.80669 45.6165H25.8097C27.3592 45.6165 28.6164 44.3532 28.6164 42.8098V34.4339H46.0751C46.8963 34.4339 47.5645 35.102 47.5645 35.9233V42.7059C47.5645 43.5271 46.8964 44.1953 46.0751 44.1953H30.2809C29.8844 44.1953 29.5631 44.5166 29.5631 44.9131C29.5631 45.3096 29.8844 45.6309 30.2809 45.6309H46.075C47.6878 45.6309 49 44.3188 49 42.7059V35.9233C49 34.3104 47.6879 32.9984 46.075 32.9984H45.6782V30.8161H46.075C47.6878 30.8161 49 29.504 49 27.8912V21.1086C49 19.4957 47.6879 18.1836 46.075 18.1836H45.6782V16.0015H46.075V16.0017ZM2.80669 27.0272H25.8097C26.1395 27.0272 26.4425 27.1444 26.6793 27.3391L14.9763 36.2463C14.583 36.5458 14.0334 36.5458 13.6401 36.2463L12.0657 35.048C12.0651 35.0475 12.0644 35.0471 12.0639 35.0466L1.93713 27.3391C2.1739 27.1444 2.47689 27.0272 2.80669 27.0272ZM1.43555 42.8098V28.7614L10.4734 35.64L1.49565 43.2106C1.45679 43.0838 1.43555 42.9493 1.43555 42.8098ZM25.8097 44.181H2.80669C2.73405 44.181 2.66313 44.1736 2.59355 44.1627L11.6438 36.5309L12.7706 37.3885C13.6758 38.0776 14.9403 38.0777 15.8458 37.3885L17.0458 36.4752L26.4202 44.0358C26.236 44.1279 26.0291 44.181 25.8097 44.181ZM27.1808 42.8051L18.2223 35.5798L27.1808 28.7614V42.8051ZM44.2428 32.9984H28.6164V30.8161H44.2428V32.9984ZM44.2428 18.1837H9.98595V16.0016H44.2428V18.1837ZM7.86345 14.5661C7.04222 14.5661 6.37402 13.898 6.37402 13.0767V6.29412C6.37402 5.47289 7.04212 4.80469 7.86345 4.80469H46.075C46.8963 4.80469 47.5645 5.47279 47.5645 6.29412V13.0767C47.5645 13.8979 46.8964 14.5661 46.075 14.5661H7.86345Z" fill="#2D3C58" />
                                        <path d="M41.9619 6.45679C40.1817 6.45679 38.7334 7.90516 38.7334 9.68533C38.7334 11.4655 40.1817 12.9138 41.9619 12.9138C43.7421 12.9138 45.1904 11.4655 45.1904 9.68533C45.1904 7.90516 43.7421 6.45679 41.9619 6.45679ZM41.9619 11.4783C40.9732 11.4783 40.1689 10.674 40.1689 9.68543C40.1689 8.69672 40.9732 7.89243 41.9619 7.89243C42.9506 7.89243 43.7548 8.69672 43.7548 9.68543C43.7548 10.674 42.9506 11.4783 41.9619 11.4783Z" fill="#2D3C58" />
                                        <path d="M45.1904 24.498C45.1904 22.7177 43.7421 21.2695 41.9619 21.2695C40.1817 21.2695 38.7334 22.7178 38.7334 24.498C38.7334 26.2782 40.1817 27.7265 41.9619 27.7265C43.7421 27.7265 45.1904 26.2783 45.1904 24.498ZM40.1689 24.498C40.1689 23.5094 40.9732 22.7051 41.9619 22.7051C42.9506 22.7051 43.7548 23.5094 43.7548 24.498C43.7548 25.4867 42.9506 26.291 41.9619 26.291C40.9732 26.291 40.1689 25.4867 40.1689 24.498Z" fill="#2D3C58" />
                                        <path d="M45.1904 39.3145C45.1904 37.5342 43.7421 36.0859 41.9619 36.0859C40.1817 36.0859 38.7334 37.5343 38.7334 39.3145C38.7334 41.0947 40.1817 42.5429 41.9619 42.5429C43.7421 42.543 45.1904 41.0948 45.1904 39.3145ZM40.1689 39.3145C40.1689 38.3258 40.9732 37.5215 41.9619 37.5215C42.9506 37.5215 43.7548 38.3258 43.7548 39.3145C43.7548 40.3031 42.9506 41.1074 41.9619 41.1074C40.9732 41.1075 40.1689 40.3031 40.1689 39.3145Z" fill="#2D3C58" />
                                    </g>
                                    <defs>
                                        <clipPath id="clip0_341_3634">
                                            <rect width="49" height="49" fill="white" />
                                        </clipPath>
                                    </defs>
                                </svg>
                            </div>
                            <h4 class="tab__title">Email Hosting</h4>
                        </div>

                        <div class="single__tab tab__btn" data-tab="dedicated">
                            <div class="tab__icon">
                                <svg width="45" height="45" viewBox="0 0 49 49" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M8.5749 4.8999C6.54875 4.8999 4.8999 6.54875 4.8999 8.5749C4.8999 10.6011 6.54875 12.2499 8.5749 12.2499C10.6011 12.2499 12.2499 10.6011 12.2499 8.5749C12.2499 6.54875 10.6011 4.8999 8.5749 4.8999ZM8.5749 10.6166C7.44954 10.6166 6.53324 9.70109 6.53324 8.5749C6.53324 7.44872 7.44954 6.53324 8.5749 6.53324C9.70027 6.53324 10.6166 7.44872 10.6166 8.5749C10.6166 9.70109 9.70027 10.6166 8.5749 10.6166Z" fill="#2D3C58" />
                                    <path d="M40.8333 8.16678C41.2843 8.16678 41.6499 7.80115 41.6499 7.35011C41.6499 6.89908 41.2843 6.53345 40.8333 6.53345C40.3822 6.53345 40.0166 6.89908 40.0166 7.35011C40.0166 7.80115 40.3822 8.16678 40.8333 8.16678Z" fill="#2D3C58" />
                                    <path d="M37.5667 8.16678C38.0177 8.16678 38.3833 7.80115 38.3833 7.35011C38.3833 6.89908 38.0177 6.53345 37.5667 6.53345C37.1156 6.53345 36.75 6.89908 36.75 7.35011C36.75 7.80115 37.1156 8.16678 37.5667 8.16678Z" fill="#2D3C58" />
                                    <path d="M42.4666 10.6167C42.9176 10.6167 43.2832 10.2511 43.2832 9.80007C43.2832 9.34903 42.9176 8.9834 42.4666 8.9834C42.0155 8.9834 41.6499 9.34903 41.6499 9.80007C41.6499 10.2511 42.0155 10.6167 42.4666 10.6167Z" fill="#2D3C58" />
                                    <path d="M39.2 10.6167C39.651 10.6167 40.0166 10.2511 40.0166 9.80007C40.0166 9.34903 39.651 8.9834 39.2 8.9834C38.7489 8.9834 38.3833 9.34903 38.3833 9.80007C38.3833 10.2511 38.7489 10.6167 39.2 10.6167Z" fill="#2D3C58" />
                                    <path d="M34.3001 8.16678C34.7511 8.16678 35.1167 7.80115 35.1167 7.35011C35.1167 6.89908 34.7511 6.53345 34.3001 6.53345C33.849 6.53345 33.4834 6.89908 33.4834 7.35011C33.4834 7.80115 33.849 8.16678 34.3001 8.16678Z" fill="#2D3C58" />
                                    <path d="M35.9334 10.6167C36.3844 10.6167 36.75 10.2511 36.75 9.80007C36.75 9.34903 36.3844 8.9834 35.9334 8.9834C35.4823 8.9834 35.1167 9.34903 35.1167 9.80007C35.1167 10.2511 35.4823 10.6167 35.9334 10.6167Z" fill="#2D3C58" />
                                    <path d="M31.0335 8.16678C31.4845 8.16678 31.8501 7.80115 31.8501 7.35011C31.8501 6.89908 31.4845 6.53345 31.0335 6.53345C30.5824 6.53345 30.2168 6.89908 30.2168 7.35011C30.2168 7.80115 30.5824 8.16678 31.0335 8.16678Z" fill="#2D3C58" />
                                    <path d="M32.6668 10.6167C33.1178 10.6167 33.4834 10.2511 33.4834 9.80007C33.4834 9.34903 33.1178 8.9834 32.6668 8.9834C32.2157 8.9834 31.8501 9.34903 31.8501 9.80007C31.8501 10.2511 32.2157 10.6167 32.6668 10.6167Z" fill="#2D3C58" />
                                    <path d="M27.7669 8.16678C28.2179 8.16678 28.5835 7.80115 28.5835 7.35011C28.5835 6.89908 28.2179 6.53345 27.7669 6.53345C27.3158 6.53345 26.9502 6.89908 26.9502 7.35011C26.9502 7.80115 27.3158 8.16678 27.7669 8.16678Z" fill="#2D3C58" />
                                    <path d="M29.4002 10.6167C29.8512 10.6167 30.2168 10.2511 30.2168 9.80007C30.2168 9.34903 29.8512 8.9834 29.4002 8.9834C28.9491 8.9834 28.5835 9.34903 28.5835 9.80007C28.5835 10.2511 28.9491 10.6167 29.4002 10.6167Z" fill="#2D3C58" />
                                    <path d="M49 13.3868V3.7632C49 1.68805 47.3119 0 45.2368 0H3.7632C1.68805 0 0 1.68805 0 3.7632V13.386C0 14.5857 0.574117 15.6432 1.45122 16.3325C0.574117 17.0226 0 18.081 0 19.2799V28.9026C0 30.1023 0.574117 31.1599 1.45122 31.8492C0.574117 32.5393 0 33.5977 0 34.7965V44.4193C0 46.4953 1.68805 48.1833 3.7632 48.1833H45.236C47.3111 48.1833 48.9992 46.4953 48.9992 44.4201V34.7965C48.9992 33.5968 48.4251 32.5393 47.548 31.85C48.4259 31.1607 49 30.1023 49 28.9035V19.2799C49 18.0802 48.4259 17.0226 47.5488 16.3333C48.4259 15.6441 49 14.5857 49 13.3868ZM47.3667 34.7965V44.4193C47.3667 45.5937 46.4112 46.5492 45.2368 46.5492H3.7632C2.58883 46.55 1.63333 45.5945 1.63333 44.4201V34.7965C1.63333 33.6222 2.58883 32.6667 3.7632 32.6667H45.236C46.4112 32.6667 47.3667 33.6222 47.3667 34.7965ZM47.3667 19.2799V28.9026C47.3667 30.077 46.4112 31.0325 45.2368 31.0325H3.7632C2.58883 31.0333 1.63333 30.0778 1.63333 28.9035V19.2799C1.63333 18.1055 2.58883 17.15 3.7632 17.15H45.236C46.4112 17.15 47.3667 18.1055 47.3667 19.2799ZM3.7632 15.5167C2.58883 15.5167 1.63333 14.5612 1.63333 13.3868V3.7632C1.63333 2.58883 2.58883 1.63333 3.7632 1.63333H45.236C46.4112 1.63333 47.3667 2.58883 47.3667 3.7632V13.386C47.3667 14.5603 46.4112 15.5158 45.2368 15.5158L3.7632 15.5167Z" fill="#2D3C58" />
                                    <path d="M8.5749 27.7667C10.6011 27.7667 12.2499 26.1179 12.2499 24.0917C12.2499 22.0656 10.6011 20.4167 8.5749 20.4167C6.54875 20.4167 4.8999 22.0656 4.8999 24.0917C4.8999 26.1179 6.54875 27.7667 8.5749 27.7667ZM8.5749 22.0501C9.70027 22.0501 10.6166 22.9656 10.6166 24.0917C10.6166 25.2179 9.70027 26.1334 8.5749 26.1334C7.44954 26.1334 6.53324 25.2179 6.53324 24.0917C6.53324 22.9656 7.44954 22.0501 8.5749 22.0501Z" fill="#2D3C58" />
                                    <path d="M40.8333 23.6834C41.2843 23.6834 41.6499 23.3177 41.6499 22.8667C41.6499 22.4157 41.2843 22.05 40.8333 22.05C40.3822 22.05 40.0166 22.4157 40.0166 22.8667C40.0166 23.3177 40.3822 23.6834 40.8333 23.6834Z" fill="#2D3C58" />
                                    <path d="M37.5667 23.6834C38.0177 23.6834 38.3833 23.3177 38.3833 22.8667C38.3833 22.4157 38.0177 22.05 37.5667 22.05C37.1156 22.05 36.75 22.4157 36.75 22.8667C36.75 23.3177 37.1156 23.6834 37.5667 23.6834Z" fill="#2D3C58" />
                                    <path d="M42.4666 26.1333C42.9176 26.1333 43.2832 25.7677 43.2832 25.3167C43.2832 24.8656 42.9176 24.5 42.4666 24.5C42.0155 24.5 41.6499 24.8656 41.6499 25.3167C41.6499 25.7677 42.0155 26.1333 42.4666 26.1333Z" fill="#2D3C58" />
                                    <path d="M39.2 26.1333C39.651 26.1333 40.0166 25.7677 40.0166 25.3167C40.0166 24.8656 39.651 24.5 39.2 24.5C38.7489 24.5 38.3833 24.8656 38.3833 25.3167C38.3833 25.7677 38.7489 26.1333 39.2 26.1333Z" fill="#2D3C58" />
                                    <path d="M34.3001 23.6834C34.7511 23.6834 35.1167 23.3177 35.1167 22.8667C35.1167 22.4157 34.7511 22.05 34.3001 22.05C33.849 22.05 33.4834 22.4157 33.4834 22.8667C33.4834 23.3177 33.849 23.6834 34.3001 23.6834Z" fill="#2D3C58" />
                                    <path d="M35.9334 26.1333C36.3844 26.1333 36.75 25.7677 36.75 25.3167C36.75 24.8656 36.3844 24.5 35.9334 24.5C35.4823 24.5 35.1167 24.8656 35.1167 25.3167C35.1167 25.7677 35.4823 26.1333 35.9334 26.1333Z" fill="#2D3C58" />
                                    <path d="M31.0335 23.6834C31.4845 23.6834 31.8501 23.3177 31.8501 22.8667C31.8501 22.4157 31.4845 22.05 31.0335 22.05C30.5824 22.05 30.2168 22.4157 30.2168 22.8667C30.2168 23.3177 30.5824 23.6834 31.0335 23.6834Z" fill="#2D3C58" />
                                    <path d="M32.6668 26.1333C33.1178 26.1333 33.4834 25.7677 33.4834 25.3167C33.4834 24.8656 33.1178 24.5 32.6668 24.5C32.2157 24.5 31.8501 24.8656 31.8501 25.3167C31.8501 25.7677 32.2157 26.1333 32.6668 26.1333Z" fill="#2D3C58" />
                                    <path d="M27.7669 23.6834C28.2179 23.6834 28.5835 23.3177 28.5835 22.8667C28.5835 22.4157 28.2179 22.05 27.7669 22.05C27.3158 22.05 26.9502 22.4157 26.9502 22.8667C26.9502 23.3177 27.3158 23.6834 27.7669 23.6834Z" fill="#2D3C58" />
                                    <path d="M29.4002 26.1333C29.8512 26.1333 30.2168 25.7677 30.2168 25.3167C30.2168 24.8656 29.8512 24.5 29.4002 24.5C28.9491 24.5 28.5835 24.8656 28.5835 25.3167C28.5835 25.7677 28.9491 26.1333 29.4002 26.1333Z" fill="#2D3C58" />
                                    <path d="M8.5749 43.2833C10.6011 43.2833 12.2499 41.6345 12.2499 39.6083C12.2499 37.5822 10.6011 35.9333 8.5749 35.9333C6.54875 35.9333 4.8999 37.5822 4.8999 39.6083C4.8999 41.6345 6.54875 43.2833 8.5749 43.2833ZM8.5749 37.5667C9.70027 37.5667 10.6166 38.4822 10.6166 39.6083C10.6166 40.7345 9.70027 41.65 8.5749 41.65C7.44954 41.65 6.53324 40.7345 6.53324 39.6083C6.53324 38.4822 7.44954 37.5667 8.5749 37.5667Z" fill="#2D3C58" />
                                    <path d="M40.8333 39.2C41.2843 39.2 41.6499 38.8343 41.6499 38.3833C41.6499 37.9323 41.2843 37.5667 40.8333 37.5667C40.3822 37.5667 40.0166 37.9323 40.0166 38.3833C40.0166 38.8343 40.3822 39.2 40.8333 39.2Z" fill="#2D3C58" />
                                    <path d="M37.5667 39.2C38.0177 39.2 38.3833 38.8343 38.3833 38.3833C38.3833 37.9323 38.0177 37.5667 37.5667 37.5667C37.1156 37.5667 36.75 37.9323 36.75 38.3833C36.75 38.8343 37.1156 39.2 37.5667 39.2Z" fill="#2D3C58" />
                                    <path d="M42.4666 41.6499C42.9176 41.6499 43.2832 41.2843 43.2832 40.8333C43.2832 40.3822 42.9176 40.0166 42.4666 40.0166C42.0155 40.0166 41.6499 40.3822 41.6499 40.8333C41.6499 41.2843 42.0155 41.6499 42.4666 41.6499Z" fill="#2D3C58" />
                                    <path d="M39.2 41.6499C39.651 41.6499 40.0166 41.2843 40.0166 40.8333C40.0166 40.3822 39.651 40.0166 39.2 40.0166C38.7489 40.0166 38.3833 40.3822 38.3833 40.8333C38.3833 41.2843 38.7489 41.6499 39.2 41.6499Z" fill="#2D3C58" />
                                    <path d="M34.3001 39.2C34.7511 39.2 35.1167 38.8343 35.1167 38.3833C35.1167 37.9323 34.7511 37.5667 34.3001 37.5667C33.849 37.5667 33.4834 37.9323 33.4834 38.3833C33.4834 38.8343 33.849 39.2 34.3001 39.2Z" fill="#2D3C58" />
                                    <path d="M35.9334 41.6499C36.3844 41.6499 36.75 41.2843 36.75 40.8333C36.75 40.3822 36.3844 40.0166 35.9334 40.0166C35.4823 40.0166 35.1167 40.3822 35.1167 40.8333C35.1167 41.2843 35.4823 41.6499 35.9334 41.6499Z" fill="#2D3C58" />
                                    <path d="M31.0335 39.2C31.4845 39.2 31.8501 38.8343 31.8501 38.3833C31.8501 37.9323 31.4845 37.5667 31.0335 37.5667C30.5824 37.5667 30.2168 37.9323 30.2168 38.3833C30.2168 38.8343 30.5824 39.2 31.0335 39.2Z" fill="#2D3C58" />
                                    <path d="M32.6668 41.6499C33.1178 41.6499 33.4834 41.2843 33.4834 40.8333C33.4834 40.3822 33.1178 40.0166 32.6668 40.0166C32.2157 40.0166 31.8501 40.3822 31.8501 40.8333C31.8501 41.2843 32.2157 41.6499 32.6668 41.6499Z" fill="#2D3C58" />
                                    <path d="M27.7669 39.2C28.2179 39.2 28.5835 38.8343 28.5835 38.3833C28.5835 37.9323 28.2179 37.5667 27.7669 37.5667C27.3158 37.5667 26.9502 37.9323 26.9502 38.3833C26.9502 38.8343 27.3158 39.2 27.7669 39.2Z" fill="#2D3C58" />
                                    <path d="M29.4002 41.6499C29.8512 41.6499 30.2168 41.2843 30.2168 40.8333C30.2168 40.3822 29.8512 40.0166 29.4002 40.0166C28.9491 40.0166 28.5835 40.3822 28.5835 40.8333C28.5835 41.2843 28.9491 41.6499 29.4002 41.6499Z" fill="#2D3C58" />
                                </svg>
                            </div>
                            <h4 class="tab__title">Dedicated Hosting</h4>
                        </div>

                    </div>
                </div>
                <div class="col-lg-7 col-md-8">
                    <div class="rts-service-four__tab--content tab__content open" id="wp">
                        <div class="tab__image">
                            <img src="assets/images/service/service__tab.png" alt="live">
                        </div>
                        <div class="tab__content--details">
                            <h5>Get more from your WordPress</h5>
                            <div class="feature">
                                <ul class="feature__list">
                                    <li class="feature__item">24/7 Customer Support</li>
                                    <li class="feature__item">Free Domain</li>
                                    <li class="feature__item">Free Website Migration</li>
                                    <li class="feature__item">easy on boarding</li>
                                </ul>
                            </div>
                            <a href="knowledgebase.php" class="all-feature border__bottom">see all feature <i class="fa-regular fa-chevron-right"></i></a>
                        </div>
                    </div>
                    <div class="rts-service-four__tab--content tab__content" id="cloud">
                        <div class="tab__image">
                            <img src="assets/images/service/service__tab.png" alt="live">
                        </div>
                        <div class="tab__content--details">
                            <h5>Get more from your Cloud Hosting</h5>
                            <div class="feature">
                                <ul class="feature__list">
                                    <li class="feature__item">24/7 Customer Support</li>
                                    <li class="feature__item">Free Domain</li>
                                    <li class="feature__item">Free Website Migration</li>
                                    <li class="feature__item">easy on boarding</li>
                                </ul>
                            </div>
                            <a href="knowledgebase.php" class="all-feature">see all feature <i class="fa-regular fa-chevron-right"></i></a>
                        </div>
                    </div>

                    <div class="rts-service-four__tab--content tab__content" id="vps">
                        <div class="tab__image">
                            <img src="assets/images/service/service__tab.png" alt="live">
                        </div>
                        <div class="tab__content--details">
                            <h5>Get more from your Vps</h5>
                            <div class="feature">
                                <ul class="feature__list">
                                    <li class="feature__item">24/7 Customer Support</li>
                                    <li class="feature__item">Free Domain</li>
                                    <li class="feature__item">Free Website Migration</li>
                                    <li class="feature__item">easy on boarding</li>
                                </ul>
                            </div>
                            <a href="knowledgebase.php" class="all-feature">see all feature <i class="fa-regular fa-chevron-right"></i></a>
                        </div>
                    </div>

                    <div class="rts-service-four__tab--content tab__content" id="email">
                        <div class="tab__image">
                            <img src="assets/images/service/service__tab.png" alt="live">
                        </div>
                        <div class="tab__content--details">
                            <h5>Get more from your Email</h5>
                            <div class="feature">
                                <ul class="feature__list">
                                    <li class="feature__item">24/7 Customer Support</li>
                                    <li class="feature__item">Free Domain</li>
                                    <li class="feature__item">Free Website Migration</li>
                                    <li class="feature__item">easy on boarding</li>
                                </ul>
                            </div>
                            <a href="knowledgebase.php" class="all-feature">see all feature <i class="fa-regular fa-chevron-right"></i></a>
                        </div>
                    </div>
                    <div class="rts-service-four__tab--content tab__content" id="dedicated">
                        <div class="tab__image">
                            <img src="assets/images/service/service__tab.png" alt="live">
                        </div>
                        <div class="tab__content--details">
                            <h5>Get more from your Dedicated</h5>
                            <div class="feature">
                                <ul class="feature__list">
                                    <li class="feature__item">24/7 Customer Support</li>
                                    <li class="feature__item">Free Domain</li>
                                    <li class="feature__item">Free Website Migration</li>
                                    <li class="feature__item">easy on boarding</li>
                                </ul>
                            </div>
                            <a href="knowledgebase.php" class="all-feature">see all feature <i class="fa-regular fa-chevron-right"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- BEST SERVICE END -->


    <!-- SUPPORT AREA -->
    <div class="rts-support">
        <div class="container">
            <div class="row">
                <div class="rts-support__wrapper">
                    <div class="rts-support__wrapper--content">
                        <h3 class="title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">24/7 World-Class Support</h3>
                        <p data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">Ran into trouble? Contact our Customer Success team any
                            time via live chat or email.
                        </p>
                        <div class="feature" data-sal="slide-down" data-sal-delay="300" data-sal-duration="800">
                            <ul class="feature__list">
                                <li class="feature__item">Receive professional WordPress support</li>
                                <li class="feature__item">Our specialists are available round</li>
                            </ul>
                        </div>
                        <a href="support.php" class="rts-btn rts-btn-primary support-btn">Get Support <i class="fa-regular fa-chevron-right"></i></a>
                    </div>
                    <div class="rts-support__wrapper--image" data-sal="slide-left" data-sal-delay="400" data-sal-duration="800">
                        <img src="assets/images/support/support__image.svg" alt="">
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- SUPPORT AREA END -->

    <!-- BLOG -->
    <section class="rts-blog pt-120">
        <div class="container">
            <div class="row justify-content-center">
                <div class="rts-section w-510 text-center">
                    <h2 class="rts-section__title" data-sal="slide-down" data-sal-delay="100" data-sal-duration="800">Latest New & Articles</h2>
                    <p class="rts-section__description" data-sal="slide-down" data-sal-delay="200" data-sal-duration="800">
                        Choose from data centers worldwide to store content your website visitors Cloudflare, has a network
                    </p>
                </div>
            </div>
            <!-- blog start -->
            <div class="row g-30">
                <div class="col-lg-4 col-sm-6">
                    <div class="rts-blog__single" data-sal="slide-down" data-sal-delay="600" data-sal-duration="800">
                        <a href="blog-details.php">
                            <img class="blog__thumb" src="assets/images/blog/blog-1.png" alt="blog post thumb">
                        </a>
                        <div class="rts-blog__single--meta">
                            <div class="cat__date">
                                <a href="#" class="cat">Web Hosting</a>
                                <span class="date">19 Sep, 2023</span>
                            </div>
                            <a href="blog-details.php" class="title">Attentive was born in 2015 help
                                sales teams VPS hosting</a>
                            <div class="rts-blog__single--author">
                                <div class="author">
                                    <img src="assets/images/author/author__one.png" alt="">
                                </div>
                                <div class="author__content">
                                    <a href="#">Mack jon</a>
                                    <span>Developer & Web serenity </span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="rts-blog__single" data-sal="slide-down" data-sal-delay="700" data-sal-duration="800">
                        <a href="blog-details.php">
                            <img class="blog__thumb" src="assets/images/blog/blog-2.png" alt="blog post thumb">
                        </a>
                        <div class="rts-blog__single--meta">
                            <div class="cat__date">
                                <a href="#" class="cat">Web Hosting</a>
                                <span class="date">19 Sep, 2023</span>
                            </div>
                            <a href="blog-details.php" class="title">Attentive was born in 2015 help
                                sales teams VPS hosting</a>
                            <div class="rts-blog__single--author">
                                <div class="author">
                                    <img src="assets/images/author/author__two.png" alt="">
                                </div>
                                <div class="author__content">
                                    <a href="#">Rubel Hossen</a>
                                    <span>Developer</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4 col-sm-6">
                    <div class="rts-blog__single" data-sal="slide-down" data-sal-delay="800" data-sal-duration="800">
                        <a href="blog-details.php">
                            <img class="blog__thumb" src="assets/images/blog/blog-3.png" alt="blog post thumb">
                        </a>
                        <div class="rts-blog__single--meta">
                            <div class="cat__date">
                                <a href="#" class="cat">Web Hosting</a>
                                <span class="date">19 Sep, 2023</span>
                            </div>
                            <a href="blog-details.php" class="title">Attentive was born in 2015 help
                                sales teams VPS hosting</a>
                            <div class="rts-blog__single--author">
                                <div class="author">
                                    <img src="assets/images/author/author__three.png" alt="">
                                </div>
                                <div class="author__content">
                                    <a href="#">Ahmad Eamin</a>
                                    <span>Developer</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row pt-100 pb-100">
                <div class="col-lg-12">
                    <div class="rts-brand__wrapper">
                        <div class="rts-brand__slider">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/01.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/02.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/03.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/04.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/05.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/06.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"> <img src="assets/images/brand/07.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/08.svg" alt=""></a>
                                    </div>
                                </div>
                                <div class="swiper-slide">
                                    <div class="rts-brand__slider--single">
                                        <a href="#"><img src="assets/images/brand/01.svg" alt=""></a>
                                    </div>
                                </div>
                            </div>
                            <span class="swiper-notification" aria-live="assertive" aria-atomic="true"></span>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>
    <!-- BLOG END -->

    <!-- NEWSLETTER AREA -->
    <div class="rts-newsletter">
        <div class="container">
            <div class="row">
                <div class="rts-newsletter__box">
                    <div class="rts-newsletter__box--content">
                        <h3 class="title">Sign up for web hosting today!</h3>
                        <form action="#" class="newsletter__form">
                            <input type="email" name="email" placeholder="Enter your email" required>
                            <button type="submit" class="btn__two secondary__bg secondary__color">Subscribe </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- NEWSLETTER AREA END -->

    <!-- FOOTER AREA START-->
        <?php include 'layout/footer/footer-three.php';?>
    <!-- FOOTER AREA END -->

    <div id="anywhere-home" class=""></div>

    <!-- Sidebar area start -->
        <?php include 'layout/partials/sidebar.php';?>
    <!-- Sidebar area end -->

    <!-- THEME PRELOADER START -->
        <?php include 'layout/partials/preloader.php';?>
    <!-- THEME PRELOADER END -->

    <!-- BACK TO TOP AREA START -->
        <?php include 'layout/partials/back-to-top.php';?>
    <!-- BACK TO TOP AREA EDN -->

    <!-- Scripts -->
        <?php include 'layout/partials/scripts.php';?>
</body>

</html>